/**
* @file GetupEngineSelector.h
* 
* Declares the GetupEngine selection module
* @author Max Risler
*/

#ifndef __GetupEngineSelector_h_
#define __GetupEngineSelector_h_

#include "Tools/Module/ModuleHandler.h"
#include "DefaultGetupEngine.h"

/**
* @class GetupEngineSelector
*
* A module selector for GetupEngine modules.
*/
class GetupEngineSelector : public ModuleSelector, public GetupEngineInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the GetupEngine module.
  */
  GetupEngineSelector(ModuleHandler &handler, const GetupEngineInterfaces& interfaces) 
    : ModuleSelector(SolutionRequest::getupEngine),
    GetupEngineInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::getupEngine,this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch (id)
    {
    case SolutionRequest::defaultGetupEngine:
      return new DefaultGetupEngine(*this);
    default:
      return 0;
    }
  }
  
  /** Executes the module*/
  bool executeParameterized(JointData& jointData)
  {
    if (selectedSolution!=0)
      return ((GetupEngine*)selectedSolution)->executeParameterized(jointData);
    else
      return false;
  }
};

#endif // __GetupEngineSelector_h_

/*
* Change log :
* 
* $Log: GetupEngineSelector.h,v $
* Revision 1.3  2004/03/08 01:38:52  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/03/06 12:06:50  dueffert
* execute with parameters renamed to avoid inheritance warnings
*
* Revision 1.2  2002/09/11 00:06:58  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:14  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.1.1.1  2002/05/10 12:40:14  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.2  2002/02/23 16:33:07  risler
* finished GetupEngine
*
* Revision 1.1  2002/02/20 16:40:50  risler
* added GetupEngine
*
*
*/
