/**
* @file HeadControlSelector.h
* 
* Definition of class HeadControlSelector
*
* @author Max Risler
* @author Martin Ltzsch
*/

#ifndef __HeadControlSelector_h_
#define __HeadControlSelector_h_

#include "Tools/Module/ModuleSelector.h"

#include "GT2003HeadControl.h"
#include "DDD2004HeadControl.h"
#include "ATH2004ERS7HeadControl.h"
#include "BB2004HeadControl.h"
#include "MSH2004HeadControl.h"

/**
* HeadControl selection module.
*
* A selector for head control modules.
*/
class HeadControlSelector : public ModuleSelector, public HeadControlInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the HeadControl module.
  */
  HeadControlSelector(ModuleHandler &handler,const HeadControlInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::headControl),
    HeadControlInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::headControl,this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::ath2004ers7HeadControl: 
      return new ATH2004ERS7HeadControl(*this);
      
    case SolutionRequest::bb2004HeadControl: 
      return new BB2004HeadControl(*this);

    case SolutionRequest::msh2004HeadControl:
      return new MSH2004HeadControl(*this);
      
    case SolutionRequest::gt2003HeadControl: 
      return new GT2003HeadControl(*this);

    case SolutionRequest::ddd2004HeadControl: 
      return new DDD2004HeadControl(*this);

    default:
      return 0;
    }
  }
};

#endif // __HeadControlSelector_h_

/*
* Change log :
* 
* $Log: HeadControlSelector.h,v $
* Revision 1.11  2004/05/23 00:04:01  loetzsch
* removed GT2004BehaviorControl and GT2004HeadControl
*
* Revision 1.10  2004/05/14 11:37:08  loetzsch
* support for multiple xabsl2engines in different modules
* preliminary GT2004HeadControl (does not work at all)
*
* Revision 1.9  2004/04/07 13:25:43  thomas
* ddd checkin after go04 - second part fixed solutions
*
* Revision 1.8  2004/04/07 12:28:57  risler
* ddd checkin after go04 - first part
*
* Revision 1.3  2004/04/02 09:27:54  Marc
* Removed Opponent Team Code
*
* Revision 1.2  2004/03/29 15:20:35  Marc
* DDD2004 Headcontrol installed
*
* Revision 1.7  2004/03/28 14:07:20  jhoffman
* renamed headcontrolmode ATH2004 in ATH2004ERS7
*
* Revision 1.6  2004/03/16 14:00:21  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.5  2004/03/08 01:38:54  roefer
*
* Interfaces should be const
* Revision 1.2  2004/03/15 17:11:39  hoffmann
* - added ATH2004HeadControl
* - added ATH2004LEDControl
* - headmotiontester shows "tilt2"
* - motion process updates odometry while no new robotPose is received, added to motion request
* - some ui adjustments
* - added member function to "field" to find out if robot is in own penalty area for use in the obstacles locator
*
* Revision 1.4  2004/02/27 15:03:48  wachter
* cloned GT2003HeadControl as MSH2004HeadContol
*
* Revision 1.3  2004/02/04 13:41:32  roefer
* Some place holders for BB2004 modules added
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/25 11:20:19  juengel
* Removed LinesHeadControl.
*
* Revision 1.2  2003/07/04 10:20:05  kudlacik
* Added BallChallangeHeadControl
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.9  2003/05/27 16:17:25  juengel
* Renamed GT2003HeadControl to HUGO2003HeadControl.
* Added GT2003HeadControl.
*
* Revision 1.8  2003/03/31 22:00:18  roefer
* LinesHeadControl added
*
* Revision 1.7  2003/03/31 21:21:55  loetzsch
* fixed the funny module solution creation
*
* Revision 1.6  2003/03/31 16:09:43  jhoffman
* made sure that only one instance of gt2002 is instantiated
*
* Revision 1.5  2003/03/31 14:57:28  jhoffman
* added "GT2003HeadControl" and put some head control stuff
* in the parent class "HeadControl"; "GT2003HeadConrol" subsumes
* "GT2002H..."
*
* Revision 1.4  2002/11/28 14:45:42  jhoffman
* added motion detector image processor and a head control that uses the information
*
* Revision 1.3  2002/09/22 18:40:55  risler
* added new math functions, removed GTMath library
*
* Revision 1.2  2002/09/10 21:07:30  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:14  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.3  2002/08/22 14:41:03  risler
* added some doxygen comments
*
* Revision 1.2  2002/08/21 07:21:51  cesarz
* EllipseHeadControl and DefaultHeadControl removed.
*
* Revision 1.1.1.1  2002/05/10 12:40:14  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.13  2002/05/03 11:49:23  juengel
* GT2002HeadControl created.
*
* Revision 1.12  2002/04/24 18:16:05  risler
* HeadState not const in HeadControl
*
* Revision 1.11  2002/04/23 10:38:28  risler
* renamed headOdometry to headState
*
* Revision 1.10  2002/04/17 17:04:39  risler
* Darmstadt GO
*
* Revision 1.9  2002/04/16 21:39:28  dueffert
* new head controller added
*
* Revision 1.8  2002/04/02 13:10:19  dueffert
* big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
*
* Revision 1.7  2002/02/21 16:28:24  risler
* removed SmoothHeadControl
*
* Revision 1.6  2002/02/21 12:46:50  loetzsch
* no message
*
* Revision 1.5  2002/02/20 16:57:52  kallnik
* new Headcontrol
* and
* new Function long abs(long)
*
* Revision 1.4  2002/02/01 20:43:41  kosen
* Bremen2001HeadControl in DefaultHeadControl integrated and redundant files removed
*
* Revision 1.3  2002/01/25 21:30:21  kosen
* Bremen2001HeadControl added
*
* Revision 1.2  2002/01/20 13:00:18  risler
* changed implementation of selecting default solution
*
* Revision 1.1  2002/01/20 10:34:38  risler
* no message
*
*
*/
