/**
 * @file ComboImageProcessor.cpp
 * 
 * This file contains a class for using two Image Processors
 * simultaneously. (useful for debugging and development of new
 * image processors).
 *
 * @author <a href=mailto:thomas.kindler@gmx.de>Thomas Kindler</a>
 *
 */
#include "ComboImageProcessor.h"
#include "Tools/Debugging/Debugging.h"
#include "Tools/Debugging/DebugDrawings.h"
#include "Tools/Debugging/DebugImages.h"
#include "Tools/FieldDimensions.h"
#include <float.h>

ComboImageProcessor::ComboImageProcessor(const ImageProcessorInterfaces& interfaces)
  : ImageProcessor(interfaces)
{

}


ComboImageProcessor::ComboImageProcessor(
  const ImageProcessorInterfaces& interfaces,
  ImageProcessor *p1, ImageProcessor *p2
)
  : ImageProcessor(interfaces)
{
  this->p1 = p1;
  this->p2 = p2;
}


ComboImageProcessor::~ComboImageProcessor()
{
  delete p1;
  delete p2;
}

void ComboImageProcessor::execute()
{
  p1->execute();
  p2->execute();
}

/*
 * Change log:
 *
 * $Log: ComboImageProcessor.cpp,v $
 * Revision 1.3  2004/03/08 01:38:59  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2004/01/21 14:31:58  loetzsch
 * Module Selectors create only the selected solution.
 * When the solution changes, the old solution is erased and the new
 * one ist created using createSolution(..)
 *
 * Revision 1.1  2004/01/15 16:00:47  kindler
 * Added ComboImageProcessor (only temporarily, for debugging only..)
 *
 */
