/**
 * @file ComboImageProcessor.h
 *
 * This file contains a class for using two Image Processors
 * simultaneously. (useful for debugging and development of new
 * image processors).
 *
 * @author <a href=mailto:thomas.kindler@gmx.de>Thomas Kindler</a>
 *
 */
#ifndef __ComboImageProcessor_h_
#define __ComboImageProcessor_h_

#include "Modules/ImageProcessor/ImageProcessor.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Debugging/Debugging.h"
#include "Tools/Debugging/DebugDrawings.h"
#include "Tools/Debugging/DebugImages.h"

/**
 * @class ComboImageProcessor
 *
 * A solution of the ImageProcessor module.
 *
 */
class ComboImageProcessor : public ImageProcessor
{
public:
  ComboImageProcessor(
    const ImageProcessorInterfaces& interfaces, 
    ImageProcessor *p1,
    ImageProcessor *p2
  );
  ~ComboImageProcessor();

  /** Executes the module */
  virtual void execute();

protected:
  ImageProcessor *p1, *p2;

private:
  ComboImageProcessor(const ImageProcessorInterfaces& interfaces);

};
#endif

/*
 * Change log:
 * 
 * $Log: ComboImageProcessor.h,v $
 * Revision 1.2  2004/03/08 01:38:59  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2004/01/15 16:00:47  kindler
 * Added ComboImageProcessor (only temporarily, for debugging only..)
 *
 *
 */
