/**
* @file GT2004ImageProcessorTools.h
*
* Tools and Definitons for GT2004ImageProcessor
*
* @author Max Risler
* @author <a href="mailto:timlaue@tzi.de">Tim Laue</a>
*/

#ifndef __GT2004ImageProcessorTools_h_
#define __GT2004ImageProcessorTools_h_

// Uncomment to use it with ColorTable32K
//~ #define CT32K_LAYOUT

#ifdef CT32K_LAYOUT
#include "Representations/Perception/ColorTable32K.h"
#else
#include "Representations/Perception/ColorTable64.h"
#endif
#include "Modules/ImageProcessor/ImageProcessorTools/ColorCorrector.h"
#include "Tools/Math/Vector2.h"
#include "Tools/Math/Geometry.h"

#ifdef CT32K_LAYOUT
#define COLOR_CLASS(y,u,v) (colorClass)((ColorTable32K&) colorTable).colorClassesUnpacked[((y>>4)<<12)|((v>>2)<<6)|(u>>2)]
#define C(px, py, layer, value) colorCorrector.correct(px,py, layer, value)
#define CORRECTED_COLOR_CLASS(px,py,y,u,v) COLOR_CLASS(C(px, py, 0, y),C(px, py, 1, u),C(px, py, 2, v))
#else
// This is a hack to speed up color table access. It obviously only works with ColorTable64
#define COLOR_CLASS(y,u,v) (colorClass)((ColorTable64&) colorTable).colorClasses[(y) >> 2][(u) >> 2][(v) >> 2]
#define CORRECTED_COLOR_CLASS(px,py,y,u,v) (colorClass)((ColorTable64&) colorTable).colorClasses[colorCorrector.correct(px,py, 0, (y)) >> 2][colorCorrector.correct(px,py, 1, (u)) >> 2][colorCorrector.correct(px,py, 2, (v)) >> 2]
#endif


/**
* @class ImageInfo
*
* Additional information about the current image,
* computed by the ImageProcessor
*/
class ImageInfo
{
public:
  /** The horizon*/
  Geometry::Line horizon;
  /** A line perpendicular to the horizon*/
  Geometry::Line vertLine;
  /** Flag, indicates whether the horizon is in the image or not*/
  bool horizonInImage;
  /** The starting point of the horizon*/
  Vector2<int> horizonStart;
  /** The end point of the horizon*/
  Vector2<int> horizonEnd;
  /** The bottom right corner of the image*/
  Vector2<int> maxImageCoordinates;
};

#endif // __GT2004ImageProcessorTools_h_

/*
* $Log: GT2004ImageProcessorTools.h,v $
* Revision 1.2  2004/05/06 16:03:56  nistico
* Supports ColorTable32K through CT32K_LAYOUT switch located into
* GT2004ImageProcessorTools.h
*
* Revision 1.1  2004/05/04 13:40:20  tim
* added GT2004ImageProcessor
*
*/
