/**
* @file GridImageProcessor2Parameters.cpp
*
* Implementation of class GridImageProcessor2Parameters.
*/

#include "GridImageProcessor2Parameters.h"

GridImageProcessor2Parameters::GridImageProcessor2Parameters()
{
  scanLineSpacing = 5;
  desiredNumberOfScanLines = 60;
  
  threshold[0] = 20;
  threshold[1] = 15;
  threshold[2] = 15;


  enableAutoColorCalibration = true;
  enableThresholdCalibration = true;
  setColorTableToDefault = false;
  resetAutoCalibration = false;
  useLongScanLinesOnly = false;
  useFixedHorizon = false;
}

GridImageProcessor2Parameters::~GridImageProcessor2Parameters()
{ }

In& operator>>(In& stream, GridImageProcessor2Parameters& parameters)
{
  char boolChar;
  stream >> parameters.scanLineSpacing;
  stream >> parameters.desiredNumberOfScanLines;
	stream >> parameters.threshold[0];
	stream >> parameters.threshold[1];
  stream >> parameters.threshold[2];
  stream >> boolChar;
  parameters.enableAutoColorCalibration = (boolChar!=0);
  stream >> boolChar;
  parameters.enableThresholdCalibration = (boolChar!=0);
  stream >> boolChar;
  parameters.resetAutoCalibration = (boolChar!=0);
  stream >> boolChar;
  parameters.setColorTableToDefault = (boolChar!=0);
  stream >> boolChar;
  parameters.useFixedHorizon = (boolChar!=0);
  stream >> boolChar;
  parameters.useLongScanLinesOnly = (boolChar!=0);
  
  return stream;
}

Out& operator<<(Out& stream, const GridImageProcessor2Parameters& parameters)
{
  stream << parameters.scanLineSpacing;
  stream << parameters.desiredNumberOfScanLines;
	stream << parameters.threshold[0]; 
	stream << parameters.threshold[1]; 
	stream << parameters.threshold[2]; 
  stream << (char)parameters.enableAutoColorCalibration;
  stream << (char)parameters.enableThresholdCalibration;
  stream << (char)parameters.resetAutoCalibration;
  stream << (char)parameters.setColorTableToDefault;
  stream << (char)parameters.useFixedHorizon;
  stream << (char)parameters.useLongScanLinesOnly;

  return stream;
}

/*
 * Change log :
 * 
 * $Log: GridImageProcessor2Parameters.cpp,v $
 * Revision 1.2  2003/11/07 11:21:19  juengel
 * GridImageProcessor2 has more parameters now.
 *
 * Revision 1.1  2003/10/06 14:10:15  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/08/25 17:25:39  juengel
 * Changed default for scan line spacing
 *
 * Revision 1.2  2003/08/18 12:08:19  juengel
 * Removed some parameters.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/05/05 12:02:45  juengel
 * Moved GridImageProcessor2Parameters from DataTypes
 *
 * Revision 1.3  2003/04/03 18:50:46  juengel
 * Added calibrationIsTolerant.
 *
 * Revision 1.2  2003/03/11 11:29:45  juengel
 * Added useColorTable
 *
 * Revision 1.1  2003/03/04 14:55:59  juengel
 * Added player perception.
 *
 */

