/** 
* @file LightingChangeTester.h
* Declaration of class LightingChangeTester.
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Jngel</A>
*/

#include "Tools/RingBufferWithSum.h"

#ifndef _LightingChangeTester_h_
#define _LightingChangeTester_h_

/**
* @class LightingChangeTester
*
* The LightingChangeTester checks if the lighting has changed.
* To know this can be important for a color calibration system.
* The calibration system has to extract green pixels from the image.
* Each such pixel must be added using the method addColor.
* If a new image is processed startImage has to be called.
* The method lightingHasChanged returns true, if the lighting has changed.
* 
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Jngel</A>
*/

class LightingChangeTester
{
public:
  /** Constructor */
  LightingChangeTester();

  /** Destructor */
  ~LightingChangeTester();

  void init();
  void startImage();
  void addColor(int channel1, int channel2, int channel3);
  bool lightingHasChanged();

private:
  int numberOfImages;
  int numberOfMeasurementsInImage;
  int accumulatedValueInImage[3];

  RingBufferWithSum<10> valuesOfLastImages[3];
};

#endif   //  _LightingChangeTester_h_

/*
 * Change log :
 * 
 * $Log: LightingChangeTester.h,v $
 * Revision 1.2  2003/12/04 17:35:24  juengel
 * comment added
 *
 * Revision 1.1  2003/12/01 16:16:54  juengel
 * Added lighting change tester.
 *
 */
