/**
* @file ManualCalibration.h
*
* Definition of class ManualCalibration
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/

#ifndef __ManualCalibration_h_
#define __ManualCalibration_h_

#include "Representations/Perception/Image.h"
#include "Representations/Perception/CameraMatrix.h"
#include "Representations/Perception/ColorTable64.h"
#include "Representations/Perception/CalibrationRequest.h"

#include "Tools/Debugging/DebugImages.h"

/**
* @class ManualCalibration
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/ 

class ManualCalibration //: public ImageProcessorInterfaces
{
public:
  ManualCalibration(
    const Image& image, 
    const CameraMatrix& cameraMatrix, 
    ColorTable64& colorTable,
    const CalibrationRequest& calibrationRequest
    );
  ~ManualCalibration();

  void execute();

  DECLARE_DEBUG_COLOR_CLASS_IMAGE(segmentedImage1);

private:
  void calibrateGreen();
  void calibrateOrange();

  unsigned long int timeOfLastGreenCalibration;
  unsigned long int timeOfLastOrangeCalibration;

  /** A reference to the image that is scanned for a goal */
  const Image& image;

  /** A reference to the camera matrix that describes position and rotation of the camera when the image was aquired */
  const CameraMatrix& cameraMatrix;

  /** A reference to the color table */
  ColorTable64& colorTable;

  /** A reference to the calibration request*/
  const CalibrationRequest& calibrationRequest;

};

#endif

/*
* Change log :
* 
* $Log: ManualCalibration.h,v $
* Revision 1.3  2003/11/03 20:16:09  juengel
* color class images can be sent from robot now
*
* Revision 1.2  2003/10/12 20:17:20  juengel
* only c64 is supported
*
* Revision 1.1  2003/10/12 11:44:58  juengel
* Added CalibrationRequest.
*
*
*/
