/**
* @file LineSegmentation.h
*
* Definition of class LineSegmentation
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/

#ifndef __LineSegmentation_h_
#define __LineSegmentation_h_

#include "SegmentBasedDetector.h"
#include "Tools/Math/Vector2.h"
#include "Representations/Perception/Image.h"
#include "../ColorSpaceUsageCounter.h"

/**
* @class LineSegmentation
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/ 

class LineSegmentation
{
public:
  LineSegmentation(
    const Vector2<int>& start, 
    const Vector2<int>& end, 
    const Image& image,
    int threshold1,
    int threshold2,
    int threshold3,
    ColorSpaceUsageCounter& colorSpaceUsageCounter
    );
  ~LineSegmentation();

  int getNumberOfSegments();
  LineSegment& getSegment(int index);

  int getNumberOfScannedPixels();
  int getAccumulatedIntensity(int channel);
  int getAccumulatedEdgeness(int channel);
private:
  void doSegmentation();



  enum {maxNumberOfSegmentsPerScanLine = 20}; /**< The maximum number of segments per line. */
  LineSegment segments[maxNumberOfSegmentsPerScanLine];
  int numberOfSegments;

  //statistics
  int numberOfScannedPixels;
  int accumulatedIntensity[3];
  int accumulatedEdgeness[3];

  const Vector2<int>& start;
  const Vector2<int>& end;
  const Image& image;
  int threshold1;
  int threshold2;
  int threshold3;
  ColorSpaceUsageCounter& colorSpaceUsageCounter;
};

#endif // __LineSegmentation_h_

/*
* Change log :
* 
* $Log: LineSegmentation.h,v $
* Revision 1.2  2003/12/04 17:35:41  juengel
* Added LineSegmentation.
*
* Revision 1.1  2003/12/04 09:43:46  juengel
* Added LineSegmentation
*
*/
