/**
 * @file EnemySpecialist2.cpp
 * 
 * This file contains the implementation of EnemySpecialist2.cpp for the RasterImageProcessor
 *
 * @author <a href="mailto:rookie_rocksta@web.de">Hyung-Won Koh</a>
 */

#include "EnemySpecialist2.h"																				
#include <algorithm>																							
#include <stdlib.h>																								
#include <time.h>																								
#include <list>																											
#include <bitset>																							
#include "Tools/RingBuffer.h"														
using namespace std;
																															
//////////////////////////////////////////////////////////////////////																
// Konstruktion/Destruktion																							
//////////////////////////////////////////////////////////////////////

EnemySpecialist2::EnemySpecialist2(RasterImageProcessor &processor,RasterStrategy &strat):
	RasterSpecialist(processor)
{
		strategy = &strat;
		preScanNeeded = true;
		postScanNeeded = false;
		width = 104;
		height = 80;				
		enemyColor = strategy->enemyColor;
		teamColor = strategy->teamColor;
		poolCtr = 0;
		maxSegs = 12;										//	maximal number of vertical shirt segments processed
		minSize = 3;		//@finalize	
		ignored = 1;		//@finalize		
		enemyColor == red ? redEnemy = true : redEnemy = false;
		
}
//--------------------------------------------------------------------------------------------------------------------------------------
EnemySpecialist2::~EnemySpecialist2()
{	
}
//--------------------------------------------------------------------------------------------------------------------------------------
void EnemySpecialist2::init()
{	
	preScanNeeded = true;
	postScanNeeded = false;
	poolCtr = 0;
	initBA();
	horDir.x = rip->getHorizon().direction.x;
	horDir.y = rip->getHorizon().direction.y;
}
//-----------------------------------------------------------------------------------------------------------------------------------
int EnemySpecialist2::getType()
{
  return 0;
  //  did not compile:
  //	return __REnemySpecialist2;
}
//--------------------------------------------------------------------------------------------------------------------------------------
void EnemySpecialist2::executePostProcessing()
{
	finalize();	
	if(segCtr==-1)
	{
		OUTPUT(idText,text, "no segments processed!");			
		return;
	}
	else if(segCtr>maxSegs)			//	there can be only maxSegs
		format();

	drawBA();	//	draw in ImageProcessor_obstacels into image in RC		

	perHorDir.x = horDir.y*(-1);
	perHorDir.y = horDir.x;
	OUTPUT(idText,text, "#~perHorDir.x = "<<perHorDir.x<<", perHorDir.y = "<<perHorDir.y);				
	//Vector3<int> *PointerArray[12];		//	array of Pointer to Vector2<int>-arrays, initialized to 10 ( maximal 4 enemys per 3 shirtSegments allowed)
	for(register int s = 0; s <= segCtr; s++)				//	init as much arrays as segments processed by finalize();
	{	
		Shirts[s][0].x = 1;															//	counter of shirt Lp in segment s		
	}
	for(register int i = 0; i < poolCtr; i++)
	{
		
		if(ShirtBA[Pool[i].x]>=0)
		{
			seg = ShirtBA[Pool[i].x];	
			Shirts[seg][Shirts[seg][0].x].x = Pool[i].x;
			Shirts[seg][Shirts[seg][0].x].y = Pool[i].y;
			Shirts[seg][Shirts[seg][0].x].z = Pool[i].z;	
			LINE(imageProcessor_obstacles,Pool[i].x*rip->marginX,
				Pool[i].y*rip->marginY, 
				Pool[i].z*rip->marginX,
				Pool[i].y*rip->marginY, 1, Drawings::ps_solid, Drawings::red);
			Shirts[seg][0].x++;

		}
		else if(ShirtBA[Pool[i].z]>=0)
		{			
			seg = ShirtBA[Pool[i].z];
			Shirts[seg][Shirts[seg][0].x].x = Pool[i].x;
			Shirts[seg][Shirts[seg][0].x].y = Pool[i].y;
			Shirts[seg][Shirts[seg][0].x].z = Pool[i].z;	
			LINE(imageProcessor_obstacles,Pool[i].x*rip->marginX,
				Pool[i].y*rip->marginY, 
				Pool[i].z*rip->marginX,
				Pool[i].y*rip->marginY, 1, Drawings::ps_solid, Drawings::red);
			Shirts[seg][0].x++;

		}	
	}
	//	shirt color segments processed here, now merge to player segments by 
	//	checking if enemy || black || gray || white color is not between segments space	
	



	initDoBool(false, segCtr);		
	
	horFalls = (horDir.y > 0);
	horFallsBlunt = (horFalls && horDir.x < horDir.y);
	horRises = (horDir.y < 0);
	horRisesBlunt = (horRises && horDir.x < horDir.y*(-1));
	horizon = strategy->horizon;

	if(perHorDir.y == 0)
	{
		perNorm.x = 1.0;
		perNorm.y = 0.0;
		OUTPUT(idText,text, "perNormX = 1, perNormY = 0");		
	}
	else
	{
		perNorm.y = 1.0;
		perNorm.x = perHorDir.x / perHorDir.y;		//	x-add-value to 1 perdicular to horizon		
		OUTPUT(idText,text, "perNorm.x = "<<perNorm.x<<", perNorm.y = "<<perNorm.y);			
	}
	for(int j = 0; j<segCtr; j++)
	{
		ctr1 = Shirts[j][0].x;
		ctr2 = Shirts[j+1][0].x;		
		half1 = (int) (ctr1 / 2 )+1;
		half2 = (int) (ctr2 / 2 )+1;
		ctr1--;
		ctr2--;

		isAbove = (Shirts[j][1].y > Shirts[j+1][1].y);		//	top of right segment is higher than top of left segment
		isBelow = (Shirts[j][ctr1].y < Shirts[j+1][ctr2].y); //	bottom of right segment is lower than bottom of left segment
		//bool doMerge = true;
		diffLp =0;
		if(isAbove)
		{
			if(isBelow)	//	left segment < right segment
			{
				if(areDifferent(Shirts[j][ctr1].x,Shirts[j][ctr1].y,Shirts[j+1][ctr2].x,Shirts[j+1][ctr2].y,3))
					diffLp++;
				if(areDifferent(Shirts[j][half1].z,Shirts[j][half1].y,Shirts[j+1][half2].x,Shirts[j+1][half2].y,3))
					diffLp++;
				if(areDifferent(Shirts[j][1].x,Shirts[j][1].y,Shirts[j+1][1].x,Shirts[j+1][1].y,3))
					diffLp++;
				if(diffLp == 0 || diffLp == 1)
					DoMerge[j] = true;
			}
			else
			{
				if(areDifferent(Shirts[j][ctr1].z,Shirts[j][ctr1].y,Shirts[j+1][ctr2].z,Shirts[j+1][ctr2].y,3))
					diffLp++;
				if(areDifferent(Shirts[j][half1].z,Shirts[j][half1].y,Shirts[j+1][half2].x,Shirts[j+1][half2].y,3))
					diffLp++;
				if(areDifferent(Shirts[j][1].x,Shirts[j][1].y,Shirts[j+1][1].x,Shirts[j+1][1].y,3))
					diffLp++;				
				if(diffLp == 0 || diffLp == 1)
					DoMerge[j] = true;
			}
		}
		else 
		{
			if(isBelow)
			{
				if(areDifferent(Shirts[j][ctr1].x,Shirts[j][ctr1].y,Shirts[j+1][ctr2].x,Shirts[j+1][ctr2].y,3))
					diffLp++;
				if(areDifferent(Shirts[j][half1].z,Shirts[j][half1].y,Shirts[j+1][half2].x,Shirts[j+1][half2].y,3))
					diffLp++;
				if(areDifferent(Shirts[j][1].z,Shirts[j][1].y,Shirts[j+1][1].z,Shirts[j+1][1].y,3))
					diffLp++;
				if(diffLp == 0 || diffLp == 1)
					DoMerge[j] = true;
			}
			else
			{
				if(areDifferent(Shirts[j][ctr1].z,Shirts[j][ctr1].y,Shirts[j+1][ctr2].z,Shirts[j+1][ctr2].y,3))
					diffLp++;
				if(areDifferent(Shirts[j][half1].z,Shirts[j][half1].y,Shirts[j+1][half2].x,Shirts[j+1][half2].y,3))
					diffLp++;
				if(areDifferent(Shirts[j][1].z,Shirts[j][1].y,Shirts[j+1][1].z,Shirts[j+1][1].y,3))
					diffLp++;
				if(diffLp == 0 || diffLp == 1)
					DoMerge[j] = true;
			}			
		}
		if(DoMerge[j])
		{
			OUTPUT(idText,text, " merge segments");
		}
		else
		{
				OUTPUT(idText,text, " merge not");
		}
		//	merge, if doMerge == true; save y-Order and 1 Lp per line
	}
	


		for(register int k = 0; k <=segCtr; k++)
		{
			getMostLeft(k);
			while(DoMerge[k])
			{
				k++;
			}
			getMostRight(k);
			LINE(imageProcessor_obstacles,mostLeft.x*rip->marginX,
					mostLeft.y*rip->marginY, 
					mostRight.x*rip->marginX,
					mostRight.y*rip->marginY, 0.5, Drawings::ps_solid, Drawings::yellow);
			xValue = mostRight.x - mostLeft.x;
			yValue = mostRight.y - mostLeft.y;
			//OUTPUT(idText,text, "shirt "<< (k+1)<<": "<<xValue<<", "<<yValue<<"(xValue, yValue)");
			stepLength = xValue >>3;
			OUTPUT(idText,text, "footSearchRange shirt "<<(k+1)<<" = "<<stepLength);			
			stepLength++;
			searchAddY =3*yValue/xValue;
			footPoint = mostLeft;
			footDbl.x = (double)footPoint.x*rip->marginX;
			footDbl.y = (double)footPoint.y* rip->marginY;
			if(redEnemy)
			{
				for(searchLine.x = (double)mostLeft.x,
					searchLine.y = (double)mostLeft.y;
				searchLine.x < (double)mostRight.x;
				searchLine.x += 3.0,
					searchLine.y +=searchAddY)
				{
					tmpPoint.x = (int)searchLine.x;
					tmpPoint.y = (int)searchLine.y;
					tmpPoint = getDeepestReds(tmpPoint, stepLength);
					tmpPoint = getDeepestReds(tmpPoint, 1);

					tmpDbl.x = (double)tmpPoint.x * rip->marginX;
					tmpDbl.y = (double)tmpPoint.y * rip->marginY;
					if(Geometry::getDistanceToLine(horizon, tmpDbl) > Geometry::getDistanceToLine(horizon, footDbl) )
					{
						footDbl = tmpDbl;
					}
					//DOT(imageProcessor_obstacles, (int)footDbl.x,(int)footDbl.y, Drawings::red, Drawings::red);
				}
			}
			else
			{
				for(searchLine.x = (double)mostLeft.x,
					searchLine.y = (double)mostLeft.y;
				searchLine.x < (double)mostRight.x;
				searchLine.x += 3.0,
					searchLine.y +=searchAddY)
				{
					tmpPoint.x = (int)searchLine.x;
					tmpPoint.y = (int)searchLine.y;
					tmpPoint = getDeepestBlue(tmpPoint, stepLength);
					tmpPoint = getDeepestBlue(tmpPoint, 1);
					tmpDbl.x = (double)tmpPoint.x * rip->marginX;
					tmpDbl.y = (double)tmpPoint.y * rip->marginY;
					if(Geometry::getDistanceToLine(horizon, tmpDbl) > Geometry::getDistanceToLine(horizon, footDbl) )
					{						
						footDbl = tmpDbl;							
					}
					//DOT(imageProcessor_obstacles, (int)footDbl.x,(int)footDbl.y, Drawings::red, Drawings::red);
				}
			}
			DOT(imageProcessor_obstacles, (int)footDbl.x,(int)footDbl.y, Drawings::yellow, Drawings::red);					
			Vector2<int> pointOnField;
			Geometry::calculatePointOnField((int)footDbl.x,(int)footDbl.y,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField);
       
			// generate enemy percept
      SinglePlayerPercept percept;
			percept.offset.x=pointOnField.x;
			percept.offset.y=pointOnField.y;
			percept.validity=0.9876;
			//OUTPUT(idText,text,"EnemyValidity: "<< percept.validity);			 			 
			if(redEnemy)
			 rip->playersPercept.addRedPlayer(percept);
			else 
			 rip->playersPercept.addBluePlayer(percept);		
		}
}
//--------------------------------------------------------------------------------------------------------------------------------------
void EnemySpecialist2::applyToShirts(int x, int y)
{
	if(!strategy->insideShirt)
	{		
		left = x;
		return;
	}
	else 
	{
		if(x - left < 2)
		{			
			return;
		}
		else		//	valid Shirt Lp found
		{
			applyToBA(left,x);
			//DOT(imageProcessor_obstacles, x*rip->marginX,y*rip->marginY, Drawings::pink, Drawings::green);
			if(poolCtr <300)
			{
				Pool[poolCtr].x = left;		//	starting Point of Lp
				Pool[poolCtr].y = y;					//	height of Lp
				Pool[poolCtr].z = x;					//	ending Point of Lp
				poolCtr++;
			}
			LINE(imageProcessor_obstacles,left*rip->marginX,y*rip->marginY, 
				x*rip->marginX,y*rip->marginY, 0.5, Drawings::ps_solid, Drawings::orange);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------
//	creates a segmentation of found enemy-Lp with supposing 2 failure Lps, not tested yet
/*
void EnemySpecialist2::finalize(ShirtBA)
{
	bool inLp = false;		//	false, if ShirtBA[i] ==0;	
	int countBorder = 0;	//	counts the Lp-openings and closings
	segCtr=0;							//	counts the segments				
	for(int i = 0; i <=rasterWidth; i++)
	{
		if(!inLp)
		{
			if(ShirtBA[i]==0)
				continue;
			else if(ShirtBA[i] == 1 || ShirtBA[i] == 2)
			{
				countBorder += ShirtBA[i];
				if(countBorder >2)
				{
					inLp = true;
					segCtr++;
					ShirtBA[i] = segCtr;
					continue;
				}
				else		// countBorder <=2
				{
				ShirtBA[i] = 0;
				continue;
				}
			}
			else if(ShirtBA[i] <0)
			{
				countBorder +=ShirtBA[i];
				ShirtBA[i] = 0;
				continue;
			}
			else	//	ShirtBA[i] >2
			{
				inLp = true;
				segCtr++;
				countBorder += ShirtBA[i];
				ShirtBA[i] = segCtr;
				continue;
			}
		}
		else		//	inLp == true, means that we are in segment area with min. 3 Lp
		{
			if(ShirtBA[i]==0)
			{
				ShirtBA[i] = segCtr;
				continue;
			}
			else if(ShirtBA[i]>0)
			{
				countBorder += ShirtBA[i];
				ShirtBA[i]=segCtr;
				continue;
			}
			else	//	ShirtBA[i] <0
			{
				countBorder+=ShirtBA[i];
				if(countBorder >= 0 && countBorder <= 2)	//	out of segment found!
				{
					inLp = false;
					ShirtBA[i] = segCtr;
					continue;								
				}
				else if(countBorder <0)
				{
					OUTPUT(idText,text,  "Error in finalize(Borders), countBorder went negative!!");	
					continue;
				}
				else	//countBorder stays > 2, set ShirtBA[i] to segmentnumber and go on
				{
					ShirtBA[i] = segCtr;
					continue;
				}
			}//	else ShirtBA[i] <0
		}	//	else if(isClear)
	}	//	close for-Cyle
	OUTPUT(idText,text, segCtr << " segments processed!");			
}
*/

/*
*		@method finalize
*		merges potential shirt-Lps to shirts, a shirt consists at least of this->minSize Lps in this version!
*		basic version, to do: segmentation parallel to horizon
*/
void EnemySpecialist2::finalize()
{
	segCtr = -1;
	inLp = false;		//	false, if ShirtBA[i] ==0;	
	borderCtr = 0;	//	counts the Lp-openings and closings		
	bool isShirt = false;
	int bTag = 0;
	for(int i = 0; i <=104; i++)
	{
		if(!inLp)
		{
			if(ShirtBA[i]==0)
			{
				ShirtBA[i]--;
				continue;
			}			
			else	//	ShirtBA[i] >0
			{
				borderCtr += ShirtBA[i];
				if(borderCtr <= ignored)
				{
					ShirtBA[i] = -1;
					continue;
				}
				else
				{
					bTag = i;
					inLp = true;
					segCtr++;
					isShirt = (borderCtr >= minSize);		
					ShirtBA[i] = segCtr;
					continue;
				}
			}
		}
		else		// in segment area
		{
			if(ShirtBA[i]==0)
			{
				ShirtBA[i] = segCtr;
				continue;
			}
			else if(ShirtBA[i]>0)
			{
				borderCtr += ShirtBA[i];
				if(!isShirt)
					isShirt = (borderCtr >= minSize);
				ShirtBA[i]=segCtr;
				continue;
			}
			else	//	ShirtBA[i] <0
			{
				borderCtr+=ShirtBA[i];				
				if(borderCtr <= ignored)	//	out of segment found!
				{
					if(!isShirt)
					{
						for(int j = bTag; j <= i; j++)
						{
							ShirtBA[j] = -1;
						}
						segCtr--;
						inLp = false;
						continue;
					}
					else	//Shirt found
					{
						inLp = false;
						isShirt = false;
						ShirtBA[i] = segCtr;
						continue;
					}
				}
				else if(borderCtr <0)
				{
					OUTPUT(idText,text,  "Error in finalize(Borders), borderCtr went negative!!");	
					continue;
				}
				else	//	borderCtr > ignored
				{
					ShirtBA[i] = segCtr;
					continue;
				}				
			}//	else ShirtBA[i] <0
		}	//	else inLp == true
	}	//	close for-Cyle
	OUTPUT(idText,text, (segCtr+1) << " segments processed_#");
}
//--------------------------------------------------------------------------------------------------------------------------------------
/*		@method areDifferent(Vector2<int> start,Vector2<int> end, int stepSize);
*		checks 3 middle points in the space between two points of two shirt-segments
*		@param startX: point.x of left segment		
*		@param startY: point.x of left segment
*		@param endX: point.x of right segment
*		@param endY: point.y of right segment
*		@stepSize: (half length)/stepSize = distance between middle and next scan point , should be >= 2, the higher stepSize is the closer the scan points get to the middle
*		@return true: if green, yellow, skyblue, teamColor seen;
*		@return false: else;
*/
bool EnemySpecialist2::areDifferent(int startX, int startY, int endX, int endY, int stepSize)
{
	LINE(imageProcessor_obstacles,startX*rip->marginX,
					startY*rip->marginY, 
					endX*rip->marginX,
					endY*rip->marginY, 0.5, Drawings::ps_solid, Drawings::white);
	xDist = endX - startX;
	yDist = endY - startY;
	xDistHalf = (int)xDist/2;
	yDistHalf = (int)yDist/2;
	middle.x = startX + xDistHalf ;
	middle.y = startY + yDistHalf ;
	middleColor = getColorFromRaster(middle.x, middle.y);	
	DOT(imageProcessor_obstacles, middle.x*rip->marginX,middle.y*rip->marginY, Drawings::white, Drawings::green);					
	if(middleColor == green)
		return true;
	else
	{
		xSteps = xDistHalf/stepSize;
		ySteps = yDistHalf/stepSize;
		left1.x = middle.x - xSteps;
		left1.y = middle.y - ySteps;
		leftColor = getColorFromRaster(left1.x, left1.y);
		DOT(imageProcessor_obstacles, left1.x*rip->marginX,left1.y*rip->marginY, Drawings::white, Drawings::green);					
		if(leftColor == green)
			return true;
		else
		{
			right1.x = middle.x + xSteps;
			right1.y = middle.y + ySteps;
			rightColor = getColorFromRaster(right1.x, right1.y);
			DOT(imageProcessor_obstacles, right1.x*rip->marginX,right1.y*rip->marginY, Drawings::white, Drawings::green);				
			if(rightColor == green)
				return true;
			else
			{
				if(middleColor == enemyColor || leftColor == enemyColor || rightColor == enemyColor)
					return false;
				else if((middleColor == yellow && leftColor == yellow && rightColor == yellow) 
					|| (middleColor == skyblue && leftColor == skyblue && rightColor == skyblue)
					|| middleColor == teamColor || leftColor == teamColor || rightColor == teamColor)
					return true;				
			}
		}
	}return	false;
}
/*	//Heuristik zur berechnung des Fusspunktes eines Shirt-segments, vorerst verworfen...
//----------------------------------------------------------------------------------------------------------------
void EnemySpecialist2::findDeepestShirtPointLeft(Vector2<int> startScanAt, int step, colorClass searchColor, int shirtWidth)
{	
	scanStepLeft.x = perNorm.x*step;
	scanStepLeft.y = perNorm.y*step;
	OUTPUT(idText,text, " scanVector: "<<scanStepLeft.x <<", "<< scanStepLeft.y);				
	scanStepRight = turnPast(scanStepLeft);
	OUTPUT(idText,text, " scanVector: "<<scanStepRight.x <<", "<< scanStepRight.y);				
	horNorm = turnPast(perNorm);
	scanOutOfBounds = false;
	deepestShirt = findColor(startScanAt, scanStepLeft.x, scanStepLeft.y, green, true);		
	DOT(imageProcessor_obstacles, deepestShirt.x*rip->marginX, deepestShirt.y*rip->marginY, Drawings::green, Drawings::green);
	if(scanOutOfBounds)
	{	
		if(deepestShirt.y+scanStepLeft.y < height )		//	out of raster to the left
		{
			scanOutOfBounds = false;
			deepestShirt = findColor(deepestShirt, 0,step, green, true);		
			if(scanOutOfBounds)
			{				
				deepestShirt.x = 1;
				deepestShirt.y = height-1;
				return;			
			}
			else
			{
				deepestShirt = findColor(deepestShirt, 0, 1, green, true);	//	exact scan				
				deepestShirt = findColor(deepestShirt, horNorm.x, horNorm.y, green, true, shirtWidth);
				if(scanOutOfBounds)
				{
					return;
				}
				else
				{
					deepestShirt = findColor(deepestShirt, scanStepLeft.x, scanStepLeft.y, green, true);
					deepestShirt = findColor(deepestShirt, perNorm.x, perNorm.y, green, true);
					return;
				}
			}
		}
		else		//	scan out of y-Axis
		{
			deepestShirt.y = height-1;
			deepestShirt = findColor(deepestShirt, step*(-1),0,green, true);
			return;
		}
	}
	else	//	first Scan not out of raster
	{
		deepestShirt = findColor(deepestShirt, perNorm.x, perNorm.y, green, true);
		deepestShirt = findColor(deepestShirt, horNorm.x, horNorm.y, green, true, shirtWidth);
		if(scanOutOfBounds)
		{
			return;
		}
		else
		{
			deepestShirt = findColor(deepestShirt, scanStepLeft.x, scanStepLeft.y, green, true);
			deepestShirt = findColor(deepestShirt, perNorm.x, perNorm.y, green, true);
			return;
		}
	}
}
//----------------------------------------------------------------------------------------------------------------
void EnemySpecialist2::findDeepestShirtPointRight(Vector2<int> startScanAt, int step, colorClass searchColor, int shirtWidth)
{	
	scanStepRight.x = perNormX*step;
	scanStepRight.y = perNormY*step;
	scanStepLeft = turnFuture(scanStepRight);
	horNorm = turnFuture(perNorm);

	scanOutOfBounds = false;
	deepestShirt = findColor(startScanAt, scanStepDist.x, scanStepDist.y, green, true);		
	DOT(imageProcessor_obstacles, deepestShirt.x*rip->marginX, deepestShirt.y*rip->marginY, Drawings::green, Drawings::green);
	if(scanOutOfBounds)
	{	
		if(startScanAt.x+scanStepDist.x < 0 ||startScanAt.x+scanStepDist.x > width)		//	scan out of x-Axis
		{
			scanOutOfBounds = false;
			deepestShirt = findColor(deepestShirt, 0,step, green, true, shirtWidth);	
			if(scanOutOfBounds)
			{
				if(deepestShirt.x+scanStepDist.x <0)
				{
					deepestShirt.x = 1;
					deepestShirt.y = height-1;
					return;
				}
				else
				{
					deepestShirt.x = width-1;
					deepestShirt.y = height-1;
					return;
				}
			}
			else
			{
				deepestShirt = findColor(deepestShirt, 0, 1, green, true, shirtWidth);
				return;
			}
		}
		else		//	scan out of y-Axis
		{
			if(horFalls)
			{
				deepestShirt.y = height-1;
				deepestShirt = findColor(deepestShirt, -1, 0, green, true, shirtWidth);
			}
			else
			{
				deepestShirt.y = height-1;
				deepestShirt = findColor(deepestShirt, 1, 0, green, true, shirtWidth);			
			}
		}
	}
	else	//	first Scan not out of raster
	{
		if(horFalls)
		{
			turnPast(scanStepDist.x, scanStepDist.y);
			scanOutOfBounds = false;
			deepestShirt = findColor(deepestShirt, scanStepDist.x,scanStepDist.y, green, true, shirtWidth);		
			if(scanOutOfBounds)
			{
				deepestShirt = findColor(deepestShirt, step*(-3), 0,green, true, shirtWidth);	
				return;
			}
			else
			{
				turnFuture(scanStepDist.x, scanStepDist.y);
				scanOutOfBounds = false;
				deepestShirt = findColor(deepestShirt,scanStepDist.x,scanStepDist.y, green, true, shirtWidth);		
				if(scanOutOfBounds)
				{				
					deepestShirt = findColor(deepestShirt, step*(-3), 0,green, true, shirtWidth);	
					return;
				}
				else
				{
					turnPast(scanStepDist.x, scanStepDist.y);
					scanOutOfBounds = false;
					deepestShirt = findColor(deepestShirt,scanStepDist.x,scanStepDist.y, green, true, shirtWidth);		
					deepestShirt = findColor(deepestShirt, step*(-3), 0,green, true, shirtWidth);	
					return;
				}
			}
		}
		else
		{
			turnPast(scanStepDist.x, scanStepDist.y);
			scanOutOfBounds = false;
			deepestShirt= findColor(deepestShirt,scanStepDist.x,scanStepDist.y, green, true, shirtWidth);		
			if(scanOutOfBounds)
			{
				deepestShirt = findColor(deepestShirt, step*(-3), 0,green, true, shirtWidth);	
				return;
			}
			else
			{
				turnFuture(scanStepDist.x, scanStepDist.y);
				scanOutOfBounds = false;
				deepestShirt = findColor(deepestShirt,scanStepDist.x,scanStepDist.y, green, true, shirtWidth);		
				if(scanOutOfBounds)
				{					
					deepestShirt = findColor(deepestShirt, step*(-3), 0,green, true, shirtWidth);	
					return;
				}
				else
				{
					turnPast(scanStepDist.x, scanStepDist.y);
					scanOutOfBounds = false;
					deepestShirt = findColor(deepestShirt,scanStepDist.x,scanStepDist.y, green, true, shirtWidth);		
					deepestShirt = findColor(deepestShirt, step*(-3), 0,green, true, shirtWidth);	
					return;
				}
			}

		}
	}
}

//----------------------------------------------------------------------------------------------------------------
Vector2<int> EnemySpecialist2::findColor(Vector2<int> startScanAt, double stepX, double stepY, colorClass searchColor, bool findIt, int shirtWidth)
{	
	for(scanPoint.y = startScanAt.y + stepY,
		scanPoint.x = startScanAt.x + stepY,
		searchCtr = (int) shirtWidth / stepX +1;
	scanPoint.y < height 
		&& scanPoint.y>0 
		&& scanPoint.x < width 
		&& scanPoint.x >0
		&& searchCtr>0;
	scanPoint.y+=stepY, 
		scanPoint.x+=stepX,
		searchCtr--)
	{
		DOT(imageProcessor_obstacles, (int)scanPoint.x*rip->marginX, (int)scanPoint.y*rip->marginY, Drawings::yellow, Drawings::black);						
		if(findIt)
		{
			if(getColorFromRaster((int)scanPoint.x,(int)scanPoint.y)==searchColor)
			{
				foundPoint1.x = (int)(scanPoint.x-stepX);
				foundPoint1.y = (int)(scanPoint.y-stepY);
				DOT(imageProcessor_obstacles, foundPoint1.x*rip->marginX, 
					foundPoint1.y*rip->marginY, Drawings::green, Drawings::red);
				return foundPoint1;
			}
		}
		else
		{
			if(getColorFromRaster((int)scanPoint.x,(int)scanPoint.y)!=searchColor)
			{
				foundPoint1.x = (int)(scanPoint.x);
				foundPoint1.y = (int)(scanPoint.y);
				DOT(imageProcessor_obstacles, foundPoint1.x*rip->marginX, 
					foundPoint1.y*rip->marginY, Drawings::green, Drawings::red);	
				return foundPoint1;
			}
		}
	}
	foundPoint1.x = (int)(scanPoint.x-stepX);
	foundPoint1.y = (int)(scanPoint.y-stepY);
	scanOutOfBounds = true;
	return foundPoint1;
}
//----------------------------------------------------------------------------------------------------------------
Vector2<int> EnemySpecialist2::findColor(Vector2<int> startScanAt, double stepX, double stepY, colorClass searchColor, bool findIt)
{	
	for(scanPoint.y = startScanAt.y + stepY,
		scanPoint.x = startScanAt.x + stepY;
	scanPoint.y < height 
		&& scanPoint.y>0 
		&& scanPoint.x < width 
		&& scanPoint.x >0;		
	scanPoint.y+=stepY, 
		scanPoint.x+=stepX)
	{
		DOT(imageProcessor_obstacles, (int)scanPoint.x*rip->marginX, (int)scanPoint.y*rip->marginY, Drawings::black, Drawings::yellow);						
		if(findIt)
		{
			if(getColorFromRaster((int)scanPoint.x,(int)scanPoint.y)==searchColor)
			{
				foundPoint1.x = (int)(scanPoint.x-stepX);
				foundPoint1.y = (int)(scanPoint.y-stepY);
				DOT(imageProcessor_obstacles, foundPoint1.x*rip->marginX, 
					foundPoint1.y*rip->marginY, Drawings::green, Drawings::black);
				return foundPoint1;
			}
		}
		else
		{
			if(getColorFromRaster((int)scanPoint.x,(int)scanPoint.y)!=searchColor)
			{
				foundPoint1.x = (int)(scanPoint.x-stepX);
				foundPoint1.y = (int)(scanPoint.y-stepY);
				DOT(imageProcessor_obstacles, foundPoint1.x*rip->marginX, 
					foundPoint1.y*rip->marginY, Drawings::green, Drawings::black);	
				return foundPoint1;
			}
		}
	}
	
//	ob das geht? :)
//		while((scanPoint.x += stepDist.x)> 0 && scanPoint.x < width && (scanPoint.y +=stepDist.y) < height && getColorFromRaster((int)scanPoint.x, (int)scanPoint.y) !=searchColor)
//	{
//			scanPoint.x += stepDist.x;
//			scanPoint.y += stepDist.y;
//		}
			
	foundPoint1.x = (int)(scanPoint.x-stepX);
	foundPoint1.y = (int)(scanPoint.y-stepY);
	scanOutOfBounds = true;
	return foundPoint1;
}

*/
Vector2<int> EnemySpecialist2::getDeepestReds(Vector2<int> start, int stepSize)
{
	tmpVec.x = perNorm.x * stepSize;
	tmpVec.y = perNorm.y * stepSize;
	for(scanPoint.x = start.x+tmpVec.x,
		scanPoint.y = start.y+tmpVec.y;		
	scanPoint.y < height 
		&& scanPoint.y>0 
		&& scanPoint.x < width 
		&& scanPoint.x >0;		
	scanPoint.x+=tmpVec.x,
		scanPoint.y+=tmpVec.y)
	{
		DOT(imageProcessor_obstacles, (int)(scanPoint.x*rip->marginX+0.5), (int)(scanPoint.y*rip->marginY+0.5), Drawings::yellow, Drawings::black);						
		scanColor = getColorFromRaster((int)(scanPoint.x+0.5),(int)(scanPoint.y+0.5));
		switch(scanColor)
		{
		case green:
			foundPoint1.x = (int)(scanPoint.x-	tmpVec.x +0.5);
			foundPoint1.y = (int)(scanPoint.y-	tmpVec.y+0.5);
			return foundPoint1;			
			break;
		case orange:		
			foundPoint1.x = (int)(scanPoint.x- tmpVec.x+0.5);
			foundPoint1.y = (int)(scanPoint.y- tmpVec.y+0.5);
			return foundPoint1;						
			break;
		case blue:
			foundPoint1.x = (int)(scanPoint.x- tmpVec.x+0.5);
			foundPoint1.y = (int)(scanPoint.y- tmpVec.y+0.5);
			return foundPoint1;						
			break;
		}
	}
	foundPoint1.x = (int)(scanPoint.x- tmpVec.x+0.5);
	foundPoint1.y = (int)(scanPoint.y- tmpVec.y+0.5);
	return foundPoint1;
}

//----------------------------------------------------------------------------------------------------------------

Vector2<int> EnemySpecialist2::getDeepestBlue(Vector2<int> start, int stepSize)
{
	tmpVec.x = perNorm.x * stepSize;
	tmpVec.y = perNorm.y * stepSize;
	for(scanPoint.x = start.x+tmpVec.x,
		scanPoint.y = start.y+tmpVec.y;		
	scanPoint.y < height 
		&& scanPoint.y>0 
		&& scanPoint.x < width 
		&& scanPoint.x >0;		
	scanPoint.x+=tmpVec.x,
		scanPoint.y+=tmpVec.y)
	{
		DOT(imageProcessor_obstacles, (int)(scanPoint.x*rip->marginX+0.5), (int)(scanPoint.y*rip->marginY+0.5), Drawings::yellow, Drawings::black);						
		scanColor = getColorFromRaster((int)(scanPoint.x+0.5),(int)(scanPoint.y+0.5));
		switch(scanColor)
		{
		case green:
			foundPoint1.x = (int)(scanPoint.x-	tmpVec.x+0.5);
			foundPoint1.y = (int)(scanPoint.y-	tmpVec.y+0.5);
			return foundPoint1;			
			break;
		case orange:		
			foundPoint1.x = (int)(scanPoint.x- tmpVec.x+0.5);
			foundPoint1.y = (int)(scanPoint.y- tmpVec.y+0.5);
			return foundPoint1;						
			break;
		case red:
			foundPoint1.x = (int)(scanPoint.x- tmpVec.x+0.5);
			foundPoint1.y = (int)(scanPoint.y- tmpVec.y+0.5);
			return foundPoint1;						
			break;
		}
	}
	foundPoint1.x = (int)(scanPoint.x- tmpVec.x+0.5);
	foundPoint1.y = (int)(scanPoint.y- tmpVec.y+0.5);
	return foundPoint1;
}

//----------------------------------------------------------------------------------------------------------------
void EnemySpecialist2::getMostLeft(int shirt)
{
	mostLeft.x = Shirts[shirt][2].x;
	mostLeft.y = Shirts[shirt][2].y;
	if(horFalls)
	{
		for(register int shirtLp = 3; shirtLp < Shirts[shirt][0].x; shirtLp++)
		{
			if(Shirts[shirt][shirtLp].x < mostLeft.x+(int)((Shirts[shirt][shirtLp].y - mostLeft.y)*rip->marginX*perNorm.x))
			{
				mostLeft.x = Shirts[shirt][shirtLp].x;
				mostLeft.y = Shirts[shirt][shirtLp].y; 
			}		
		}
	}
	else
	{
		for(register int shirtLp = 3; shirtLp < Shirts[shirt][0].x; shirtLp++)
		{
			if(Shirts[shirt][shirtLp].x < mostLeft.x-(int)((Shirts[shirt][shirtLp].y - mostLeft.y)*rip->marginX*perNorm.x))
			{
				mostLeft.x = Shirts[shirt][shirtLp].x;
				mostLeft.y = Shirts[shirt][shirtLp].y; 
			}		
		}
	}
	DOT(imageProcessor_obstacles, mostLeft.x*rip->marginX, 
					mostLeft.y*rip->marginY, Drawings::black, Drawings::orange);		
}
//----------------------------------------------------------------------------------------------------------------
void EnemySpecialist2::getMostRight(int shirt)
{
	mostRight.x = Shirts[shirt][2].z;
	mostRight.y = Shirts[shirt][2].y;	
	if(horFalls)
	{
		for(register int shirtLp = 3; shirtLp < Shirts[shirt][0].x; shirtLp++)
		{
			if(Shirts[shirt][shirtLp].z > mostRight.x-(int)((Shirts[shirt][shirtLp].y - mostRight.y)*rip->marginX*perNorm.x))
			{
				mostRight.x = Shirts[shirt][shirtLp].z;
				mostRight.y = Shirts[shirt][shirtLp].y; 
			}		
		}
	}
	else
	{
		for(register int shirtLp = 3; shirtLp < Shirts[shirt][0].x; shirtLp++)
		{
			if(Shirts[shirt][shirtLp].z > mostRight.x+(int)((Shirts[shirt][shirtLp].y - mostRight.y)*rip->marginX*perNorm.x))
			{
				mostRight.x = Shirts[shirt][shirtLp].z;
				mostRight.y = Shirts[shirt][shirtLp].y; 
			}		
		}
	}
	DOT(imageProcessor_obstacles, mostRight.x*rip->marginX, 
		mostRight.y*rip->marginY, Drawings::black, Drawings::pink);		
}






/*
* Change log :
* 
* $Log: EnemySpecialist2.cpp,v $
* Revision 1.2  2004/03/17 17:43:24  cesarz
* Fixed small compile bug.
*
* Revision 1.1  2004/03/17 17:07:20  koh
* added enemySpecialist2;
*
*
*/

