/**
 * @file EnemySpecialist.h
 * 
 * This file contains the interface of the Enemy-Specialist for the RasterImageProcessor
 *
 * @author <a href="mailto:rookie_rocksta@web.de">Hyung-Won Koh</a>
 */

#ifndef ENEMYSPECIALIST2_H
#define ENEMYSPECIALIST2_H


#include "RasterSpecialist.h"
#include "Tools/Math/Geometry.h"
#include <vector>
#include "Tools/Math/Vector2.h"
#include "RasterStrategy.h"
#include "RasterImageProcessor.h"
#include "Modules/ImageProcessor/ImageProcessor.h"


class EnemySpecialist2 :public RasterSpecialist
{
typedef const unsigned char* I_Pin;
public:
	EnemySpecialist2(RasterImageProcessor &processor,RasterStrategy &strat);
	virtual ~EnemySpecialist2();	
	void executePostProcessing();
	//void invokeOnPreScan(int x,int y);	
	void applyToShirts(int x, int y);
	
	virtual int getType();
	virtual void init();

private:	
	bool horFalls,
		horFallsBlunt,
		horRises,
		horRisesBlunt,
		notFinished,
		inLp,
		isAbove,
		isBelow,
		redEnemy,
		DoMerge[12];	

	int height,
		width,		
		left,				
		poolCtr,
		segCtr,
		borderCtr,
		seg,
		maxSegs,
		minSize,
		ignored,		
		ctr1, 
		ctr2,
		half1,
		half2,	
		xDist,
		xDistHalf,		
		xSteps,
		xSteps2,
		yDist,
		yDistHalf,
		ySteps,
		ySteps2,
		first,
		last,
		enemyCtr,		
		stepLength,
		xValue,
		yValue,
		searchCtr,
		diffLp,
		ShirtBA[105];

	double xAdd,
		yAdd,			
		xAddTmp,
		yAddTmp,
		tmpTurn,
		searchAddY;

	Vector2<int> middle,
		left1,
		right1,		
		startPoint,
		footPoint,
		foundPoint1,
		deepestShirt,
		tmpPoint,
		mostLeft,
		mostRight;
		

	Vector2<double> horDir,
		perHorDir,
		scanPoint,
		scanStepLeft,
		scanStepRight,
		perNorm,
		horNorm,
		searchLine,
		tmpDbl,
		footDbl,
		tmpVec;

	Vector3<int> Pool[300],//	array of enemy-LPs with shirt-Color		
		Shirts[12][300];		//	max ~40kb

	colorClass enemyColor;
	colorClass teamColor;
	colorClass middleColor;
	colorClass leftColor;
	colorClass rightColor;
	colorClass scanColor;
	
	
	RasterStrategy *strategy;	
	Geometry::Line horizon; /**< The horizon. */	

	void finalize();

	bool areDifferent(int startX, int startY, int endX, int endY, int stepSize);

	/*
	void findDeepestShirtPointLeft(Vector2<int> startScanAt, int step, colorClass searchColor, int shirtWidth);

	void findDeepestShirtPointRight(Vector2<int> startScanAt, int step, colorClass searchColor, int shirtWidth);

	Vector2<int> findColor(Vector2<int> startScanAt, double stepX, double stepY, colorClass searchColor, bool findIt, int shirtWidth);

	Vector2<int> findColor(Vector2<int> startScanAt, double stepX, double stepY, colorClass searchColor, bool findIt);
*/

	Vector2<int> getDeepestReds(Vector2<int> start, int stepSize);

	Vector2<int> getDeepestBlue(Vector2<int> start, int stepSize);

	void getMostLeft(int shirt);

	void getMostRight(int shirt);
	//	turns vector 3 hours into future
	inline Vector2<double> turnFuture(Vector2<double> vec)
		{
		tmpTurn = vec.x;
		vec.x = vec.y*(-1);
		vec.y = tmpTurn;
		return vec;
		}
	
	//	turns vector 3 hours into past
	inline Vector2<double> turnPast(Vector2<double> vec)
		{
		tmpTurn = vec.y;
		vec.y = vec.x*(-1);
		vec.x = tmpTurn;
		return vec;
		}

	inline void applyToBA(int left, int right)
		{
		ShirtBA[left]++;
		ShirtBA[right]--;
		};
	inline void initBA()
		{
		for(register int i = 0; i<=width; i++)	
			ShirtBA[i]=0;	
		};
	inline void initDoBool(bool initValue, int end)
		{
		for(register int i = 0; i<=end; i++)	
			DoMerge[i]=initValue;
		}
	
	//	adjusts an border-array if there were too many segments found!
	inline void format()
		{
		for(register int i = width; i>=0;i--)
		{
			if(ShirtBA[i]==0)
				continue;
			else if (ShirtBA[i]>maxSegs)
				ShirtBA[i]=0;
			else if(ShirtBA[i] <= maxSegs)
			{
				segCtr = ShirtBA[i];
				return;
			}
		}
		}
	inline void drawBA()
		{
		bool drawRed = true;		
		int tmp = 0;
		//to see finalized ShirtBA Borders[]
		for(register int a = 0; a<=width;a++)
		{
			if(ShirtBA[a] == -1)
			{				
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::black);
				continue;
			}
			else if(ShirtBA[a] == tmp)
			{
				if(drawRed)
				{
					DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::red);				
				}
				else
				{
					DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::orange);				
				}
			}
			else
			{
				tmp = ShirtBA[a];
				if(drawRed)
				{
					drawRed = false;
					DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::orange);				
				}
				else
				{
					drawRed = true;
					DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::red);				
				}
			}
			/*
			if(array[a]==0)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::black);
				continue;
			}
			if(array[a]==1)			
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::yellow);
				continue;
			}
			if(array[a]==2)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::orange);
				continue;
			}
			if(array[a]==3)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::red);
				continue;
			}
			if(array[a]==4)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::pink);
				continue;
			}
			if(array[a]>4)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::white);
				continue;
			}
			if(array[a]<0)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::black, Drawings::black);
				continue;
			}*/
		}	
	};

};
#endif


/*
* Change log :
* 
* $Log: EnemySpecialist2.h,v $
* Revision 1.1  2004/03/17 17:07:20  koh
* added enemySpecialist2;
*
*
*/



