// RBallSpecialist.cpp: Implementierung der Klasse RBallSpecialist.
//
//////////////////////////////////////////////////////////////////////

#include "RBallSpecialist.h"
#include <algorithm>
#include <stdlib.h>
#include <time.h>
#include <list>
#include <bitset>
#include "Tools/RingBuffer.h"

using namespace std;

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

RBallSpecialist::RBallSpecialist(RasterImageProcessor &processor,RasterStrategy &strat):
	RasterSpecialist(processor),lines(30),columns(30)
{
		strategy = &strat;
		preScanNeeded = true;
		postScanNeeded = true;
		countSum = 0;
		maxCountSum = 0;
/*		
		for (int i=0;i<2;i++)
			maximums[i] = 10;
		
		for (int j=0;j<4;j++)
			offsets[i] = 0;

*/
}

RBallSpecialist::~RBallSpecialist()
{

}

void RBallSpecialist::executePostProcessing()
{

	if (counters[0] == 0 || counters [1] == 0) return;
		
	OUTPUT(idText,text,"ball post process");
	     
	if (calculatePairs() == false) return;	



	//jeweils bis zum rand laufen und ihn merken
	Vector2<int> left,right,top,bottom;
	
	//links
	//if (pairs[0]->v1->x == 0) left = *(pairs[0]->v1);
	left = scanWest(pairs[0]->v1.x,pairs[0]->v1.y);
	
	//rechts 
	right = scanEast(pairs[0]->v2.x, pairs[0]->v2.y );

	//oben
	top = scanNorth(pairs[1]->v2.x,pairs[1]->v2.y );

	//unten
	//if (pairs[1]->v2->x < rip->rasterHeight -1) bottom = *(pairs[1]->v1);
	bottom = scanSouth(pairs[1]->v1.x,pairs[1]->v1.y);


	
	LINE(imageProcessor_ball1,
			left.x,left.y, 
			right.x,right.y, 
			1.0, Drawings::ps_solid, Drawings::yellow);
	LINE(imageProcessor_ball1,
		top.x,top.y, 
		bottom.x,bottom.y, 
		1.0, Drawings::ps_solid, Drawings::yellow);

	
	//Testen ob man Randpunkte erwischt hat.
	//Und Austausch gegen andere Punkte aus einem sekundrem
	//Punktepaar.
	if (secPairs[1] != 0){
		if (bottom.y >= (imageHeight - 4)){
			bottom = secPairs[1]->v2;
			bottom = scanNorth(bottom.x,bottom.y);
		}
		if (top.y <= 4){ 
			top = secPairs[1]->v1;
			top = scanSouth(top.x,top.y);
		}
	}

	if (secPairs[0] != 0){
		if (left.x <= 4){
			left = secPairs[0]->v2;
			left = scanEast(left.x,left.y);
		}
		if (right.x >= (imageWidth - 4)){
			right = secPairs[0]->v1;
			right = scanWest(right.x,right.y);
		}
	}

	CIRCLE(imageProcessor_ball1, top.x, top.y,
		4, 0.7,Drawings::ps_solid, Drawings::yellow);

	CIRCLE(imageProcessor_ball1, bottom.x,bottom.y,
		4, 0.7, Drawings::ps_solid, Drawings::yellow);

	CIRCLE(imageProcessor_ball1, right.x, right.y,
		4, 0.7, Drawings::ps_solid, Drawings::yellow);
  
	CIRCLE(imageProcessor_ball1, left.x, left.y,
		4, 0.7, Drawings::ps_solid, Drawings::yellow);
	
	


	Geometry::Circle circle;
	Geometry::Circle best;
	double bestValidity = 0;
	double validity = 0;

	circle = Geometry::getCircle(left,right,top);
	validity = validateCircle(circle);
	if (validity >= bestValidity){
		best = circle;
		bestValidity = validity;
	}
	
	circle = Geometry::getCircle(left,right,bottom);
	validity = validateCircle(circle);
	if (validity >= bestValidity){
		best = circle;
		bestValidity = validity;
	}
	
	circle = Geometry::getCircle(left,bottom,top);
	validity = validateCircle(circle);
	if (validity >= bestValidity){
		best = circle;
		bestValidity = validity;
	}
	
	circle = Geometry::getCircle(bottom,right,top);
	validity = validateCircle(circle);
	if (validity >= bestValidity){
		best = circle;
		bestValidity = validity;
	}	
	addBallPercept(best,bestValidity);	

}

void RBallSpecialist::invokeOnPreScan(int x,int y){
	LinePair lp;
	
	if (!strategy->insideBall) temp = getVecFromRaster(x,y);
	else{
		//sich ein Paar merken

		lp.v1 = temp;
		lp.v2 = getVecFromRaster(x,y);
		//scanEdge(lp.v2,east,10);
		//scanEdge(lp.v1,west,10);
		//lp.nextPair = NULL;
		
		//if (counters[0] > 0)
		//	lines[counters[0]-1].nextPair = &lp;
		
		lines[counters[0]] = lp;
		counters[0]++;

		//OUTPUT(idText,text,"pair accepted: " << x << " " << y);
		LINE(imageProcessor_ball1,
			lines[(counters[0]-1)].v1.x,lines[(counters[0]-1)].v1.y, 
			lines[(counters[0]-1)].v2.x,lines[(counters[0]-1)].v2.y, 
			0.5, Drawings::ps_solid, Drawings::red);    
	}

	if (counters[0] >= maximums[0])	preScanNeeded = false;
}

void RBallSpecialist::invokeOnPostScan(int x,int y)
{	

	if (!strategy->insideBall) temp = getVecFromRaster(x,y);
	else{
		LinePair lp;
		lp.v1 = temp;
		lp.v2 = getVecFromRaster(x,y);
		if (lp.v1.y >0) lp.v1.y--;
		//lp.nextPair = NULL;
		
		//if (counters[1]>0)
		//	columns[counters[1]-1].nextPair = &lp;

		columns[counters[1]] = lp;
		counters[1]++;
		//OUTPUT(idText,text,"pair accepted: " << x << " " << y);
		LINE(imageProcessor_ball1,
			columns[(counters[1]-1)].v1.x,columns[(counters[1]-1)].v1.y, 
			columns[(counters[1]-1)].v2.x,columns[(counters[1]-1)].v2.y, 
			0.5, Drawings::ps_solid, Drawings::red);
	}
	if (counters[1] >= maximums[1])	postScanNeeded = false;
}

int RBallSpecialist::getType()
{
	return __RBallSpecialist;	
}

void RBallSpecialist::init()
{	
	//maxCountSum = maximums[0] + maximums[1];
	//countSum = 0;
	counters[0] = 0;
	counters[1] = 0;

	//columns.assign(30,NULL);
	//columns.assign(30,NULL);

	postScanNeeded = true;
	preScanNeeded = true;

	for (int i=0;i < 2;i++){
		pairs[i] = 0;
		secPairs[i] = 0;
	}

	lines.clear();
	columns.clear();

	lines.reserve(MAX_BALL_PAIRS +1);
	columns.reserve(MAX_BALL_PAIRS +1);



	currentScanline = -100;
	currentScanColumn = -100;

//	OUTPUT(idText,text,"lines-size: " << lines.size());
}

void RBallSpecialist::addBallPercept(Geometry::Circle &circle,double validity)
{	
	
	//So knnen Geisterblle weitgehend vermieden werden
	if (validity < 0.45) return;
	
	CIRCLE(imageProcessor_ball1,
		(int)circle.center.x, 
		(int)circle.center.y, 
		(int)circle.radius,
		1, Drawings::ps_solid, Drawings::blue);
    
//	OUTPUT(idText,text,"Ball-Validity: " << validity);
    
	//Ball zum Percept hinzufgen
	Vector2<double> angles;
    Geometry::calculateAnglesForPoint(
		Vector2<int>((int)circle.center.x,(int)circle.center.y),
		rip->cameraMatrix, rip->image.cameraInfo, angles);
    
	rip->ballPercept.add(angles, 
		Geometry::pixelSizeToAngleSize(circle.radius,rip->image.cameraInfo),
		rip->cameraMatrix.translation, rip->cameraMatrix.isValid);
}

double RBallSpecialist::validateCircle(Geometry::Circle &circle)
{	

	/*CIRCLE(imageProcessor_ball1,
	(int)circle.center.x, 
	(int)circle.center.y, 
	(int)circle.radius,
	0.3, Drawings::ps_solid, Drawings::white);
	*/
	
	
	/*Validity using size of the radius */
	double size = 1;
	
	double maxRadius =  25  /*((double)176)/(double)7*/;
	size = circle.radius;

	if (size > maxRadius ) size = maxRadius;
	size = size/maxRadius;

	/*Validity using dirty Points*/
	double pValidity = 1;
	int points = 1;
	int validPoints = 0;
	int counts = 7;

	double r2 = circle.radius * circle.radius;
	
	int minX = (int) (circle.center.x - circle.radius);
	int minY = (int) (circle.center.y - circle.radius);
	int maxX = (int) (circle.center.x + circle.radius);
	int maxY = (int) (circle.center.y + circle.radius);

	//merging imageBounds with circle Bounds

	if (minX < 0) minX = 0;
	if (minY < 0) minY = 0;
	//if (maxX > rip->image.cameraInfo.resolutionWidth) maxX = rip->image.cameraInfo.resolutionWidth;
	//if (maxY > rip->image.cameraInfo.resolutionHeight) maxY = rip->image.cameraInfo.resolutionHeight;
	
	if (maxX > 176) maxX = 176;
	if (maxY > 144) maxY = 144;
	int margin = (int) (((maxX - minX) + (maxY - minY))/(2*counts) + (double)0.5);
	//OUTPUT(idText,text,"Margin: " << margin);
	if (margin < 2) margin = 2;

	//counting validPoints
	if (maxX > margin) maxX -= margin;
	if (maxY > margin) maxY -= margin;
	
	for (int x = minX; x < maxX; x += margin)
		for (int y = minY; y < maxY - margin; y+= margin){
		points++;
		
		colorClass color = getColor(x,y);
		
		if (Geometry::insideCircle(circle,r2,x,y)){
			if (color == orange || color == red)
				validPoints++;
			else{
				//DOT(imageProcessor_ball1, x, y, Drawings::white, Drawings::red);
			}
		}
		else if	(color == green || color == white || color == gray || 
				color == yellow || color == skyblue){
			validPoints++;
		}
		else{
			//DOT(imageProcessor_ball1, x, y, Drawings::white, Drawings::red);
		}
		
	}

	pValidity = (double)validPoints/(double)points;
	//OUTPUT(idText,text,"validPoints: " << validPoints);
	//OUTPUT(idText,text,"allPoints: " << points);
	//OUTPUT(idText,text,"Size-Validity: " << size);
	//OUTPUT(idText,text,"DirtyPoints-Validity: " << pValidity);
	//OUTPUT(idText,text,"Ball-Validity: " << (size + pValidity*4)/5);
	return (size + pValidity*2)/3 ;
}

bool RBallSpecialist::calculatePairs(){
	
	 pairs[0] = &lines[0];
	
	int maxRange = lines[0].v2.x - lines[0].v1.x;
	int range = 0;
	for (int i=1; i<counters[0] - 1;i++){
		range = lines[i].v2.x - lines[i].v1.x;
		if (range > maxRange){
		//	OUTPUT(idText,text,"pair (lr) " << lines[i].v1.x 
		//		<< " " << lines[i].v1.y << " \n " << lines[i].v2.x 
		//		<< " " << lines[i].v2.y );
			
			if (lines[i].v1.y - pairs[0]->v1.y < 10)
				secPairs[0] = pairs[0];
			pairs[0] = &lines[i];
			maxRange = range;
		}
	}

	pairs[1] = &columns[0];
	maxRange = columns[0].v1.y - columns[0].v2.y;

	for (int j=1; j<counters[1] - 1 ;j++){
		range = columns[j].v1.y - columns[j].v2.y;
		if (range >= maxRange){
		//	OUTPUT(idText,text,"pair (ou) " << columns[j].v1.x 
		//		<< " " << columns[j].v1.y << " \n " << columns[j].v2.x 
		//		<< " " << columns[j].v2.y );
			
			if (columns[j].v1.y - pairs[1]->v1.y < 10)
				secPairs[1] = pairs[1];
			pairs[1] = &columns[j];
			maxRange = range;
		}

	}
	
	return isCross( *(pairs[0]), *(pairs[1]));
}



/*
* Change log :
* 
* $Log: RBallSpecialist.cpp,v $
* Revision 1.21  2004/05/25 13:27:34  schmidtb
* modified version of rip for open-challenge
*
* Revision 1.19  2004/03/11 20:33:44  schmidtb
* new version of rip
*
* Revision 1.18  2004/03/03 12:53:18  schmidtb
* color correction integrated
*
* Revision 1.17  2004/02/26 14:31:32  schmidtb
* comment some outputs
*
* Revision 1.16  2004/02/18 14:56:19  neubach
* new Segmentation established, code not cleared at all
*
* Revision 1.15  2004/02/05 11:51:18  schmidtb
* now BoxSpecialist recognizes landmarks and goals
*
* Revision 1.14  2004/02/04 13:00:49  schmidtb
* new version of BoxSpecialist
*
* Revision 1.13  2004/02/02 13:42:12  schmidtb
* merged sources of RIP. added som functions.
*
* Revision 1.12  2003/12/17 16:39:52  schmidtb
* New version
*
* Revision 1.11  2003/12/15 13:55:32  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.10  2003/12/15 11:49:08  juengel
* Introduced CameraInfo
*
* Revision 1.9  2003/12/08 15:02:55  schmidtb
* new version of RIP
*
* Revision 1.8  2003/12/04 18:18:38  roefer
* Crude bug-fix to make it compile
*
* Revision 1.7  2003/12/04 09:51:23  schmidtb
* better BallSpecialist
*
* Revision 1.6  2003/12/03 23:59:26  roefer
* Compatibility with VC2003.NET, GUI works now
*
* Revision 1.5  2003/12/02 21:59:02  schmidtb
* New version of RasterImageProcessor
*
* Revision 1.4  2003/11/20 17:59:29  heinze
* error removed
*
* Revision 1.3  2003/11/20 10:26:56  schmidtb
* Ball Detection added
*
* Revision 1.2  2003/11/13 10:41:28  schmidtb
* renewed RBallSpeciaslist and Strategy
*
* Revision 1.1  2003/11/12 13:13:20  schmidtb
* new RasterImageProcessor added
*
*
*/
