// RBallSpecialist.h: Schnittstelle fr die Klasse RBallSpecialist.
//
//////////////////////////////////////////////////////////////////////

#ifndef RBALLSPECIALIST_H
#define RBALLSPECIALIST_H


#define MAX_BALL_PAIRS 100


#include "RasterSpecialist.h"
#include "Tools/Math/Geometry.h"
#include <vector>
#include "Tools/Math/Vector2.h"
#include "RasterStrategy.h"



class RBallSpecialist :public RasterSpecialist  
{
public:
	RBallSpecialist(RasterImageProcessor &processor,RasterStrategy &strategy);
	virtual ~RBallSpecialist();
	void invokeOnPostScan(int x, int y);
	void executePostProcessing();
	void invokeOnPreScan(int x,int y);
	virtual int getType();
	virtual void init();
	int   maximums[2];
	int   maxCountSum;
	int   countSum;
	

private:
	
	RasterStrategy *strategy;
	
	void addBallPercept(Geometry::Circle &circle,double validity);

	bool calculatePairs();

	inline bool isCross(const LinePair& horizontal,const LinePair vertical){
		return horizontal.v1.x <= vertical.v1.x 
			&& horizontal.v2.x >= vertical.v1.x
			&& vertical.v2.y <= horizontal.v1.y 
			&& vertical.v1.y >= horizontal.v1.y;
	}
		
	double validateCircle(Geometry::Circle &circle);
	
	std::vector<LinePair> columns;
	
	std::vector<LinePair> lines;
	
	//Vector2<int> *columns[MAX_BALL_PAIRS][2];

	//Vector2<int> *lines[MAX_BALL_PAIRS][2]; 
	
	int counters[2];
	
	int currentScanline;

	int currentScanColumn;

	Vector2<int> temp;
	
	Vector2<int> *p[4];

	LinePair *pairs[2];

	LinePair *secPairs[2];

	int offsets[4];

};

#endif

/*
* Change log :
* 
* $Log: RBallSpecialist.h,v $
* Revision 1.10  2004/03/11 20:33:44  schmidtb
* new version of rip
*
* Revision 1.9  2004/02/04 13:00:49  schmidtb
* new version of BoxSpecialist
*
* Revision 1.8  2003/12/08 15:02:55  schmidtb
* new version of RIP
*
* Revision 1.7  2003/12/04 18:18:38  roefer
* Crude bug-fix to make it compile
*
* Revision 1.6  2003/12/04 09:51:23  schmidtb
* better BallSpecialist
*
* Revision 1.5  2003/12/02 21:59:02  schmidtb
* New version of RasterImageProcessor
*
* Revision 1.4  2003/11/28 14:50:01  dueffert
* bugs and warnings fixed
*
* Revision 1.3  2003/11/20 10:26:56  schmidtb
* Ball Detection added
*
* Revision 1.2  2003/11/13 10:41:29  schmidtb
* renewed RBallSpeciaslist and Strategy
*
* Revision 1.1  2003/11/12 13:13:20  schmidtb
* new RasterImageProcessor added
*
*
*/
