

// landmark 1 : (from top to bottom) yelloy, pink
// landmark 2 : (from top to bottom) pink, yellow
// landmark 3 : (from top to bottom) blue, pink
// landmark 4 : (from top to bottom) pink, blue


#ifndef RBridgeSpecialist_H
#define RBridgeSpecialist_H


#include "RasterSpecialist.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Math/Vector2.h"
#include "RasterStrategy.h"
#include "Tools/Math/Vector3.h"
#include <list>
#include <vector>
#include <algorithm>
#include "Representations/Perception/LandmarksPercept.h"
#include "Modules/ImageProcessor/ImageProcessorTools/MSH2004EdgeDetection.h"

using namespace std;





float getDistanceToLine(const Geometry::Line,const Vector2<int>&);



class RBridgeSpecialist :public RasterSpecialist

{

public:
	
	struct Rectangle {
		Vector2<double> upperLeft;
		Vector2<double> upperRight;
		Vector2<double> bottomLeft;
		Vector2<double> bottomRight;
		Vector2<double> center;
	};

	struct SegmentInfo {
		SegmentInfo();
		
		double lmValidityYellow;
		double lmValidityOrange;
		Rectangle rect;
		int yellow;
		int skyblue;
		int orange;
		int size;
		colorClass leftColor;
		colorClass rightColor;
		list<LinePair>* segment;
	};

	typedef Geometry::Line Line;
	typedef vector<list<RasterSpecialist::LinePair> > SVector;



	RBridgeSpecialist(RasterImageProcessor &processor,RasterStrategy &strategy);
	virtual ~RBridgeSpecialist();
	void invokeOnPostScan(int x, int y);
	void executePostProcessing();
	void invokeOnPreScan(int x,int y);
	virtual int getType();
	virtual void init();

private:
  colorClass lineColor;

	RasterStrategy *strategy;
	
	MSH2004EdgeDetection edgeScanner;
	
	std::list<LinePair> lst_pts;

	Geometry::Line horizon;
	Geometry::Line pHorizon;

	Vector2 <int> left_border;

	std::vector<list<LinePair> > segments_img;
	std::vector<SegmentInfo> infos_img;
	std::vector<Rectangle> BBox_img;
	std::vector<Vector2<int> > bottomPoints;

	void createBBox();

	void countColors(SegmentInfo& si, list<LinePair>& segment);

	void findBridgeMark(SegmentInfo& si);

	BitePoint::Position getPosition(SegmentInfo& mark);

	void scan();

	void calculateAnglesForPoint
	(
		const Vector2<double>& point, 
		const CameraMatrix& cameraMatrix, 
		const CameraInfo& cameraInfo, 
		Vector2<double>& angles
	);

	bool calculatePointOnField
	(
		const double x,
		const double y,
		const CameraMatrix& cameraMatrix,
		const CameraInfo& cameraInfo,
		Vector2<int>& pointOnField
	);

	void createValidities(SegmentInfo& info);

	inline bool isValidPoint(Vector2<int>& p){
		if (p.x >= imageWidth || p.x <= 0) return false;
		if (p.y >= imageHeight || p.y <= 0) return false;
		return true;
	}

};

#endif
