// REnemyStrategy.cpp: Implementierung der Klasse REnemyStrategy.
//
//////////////////////////////////////////////////////////////////////

#include "REnemyStrategy.h"

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

REnemyStrategy::REnemyStrategy(RasterImageProcessor &processor):
	RasterStrategy(processor)
{
  //einen neuen BallSpezialisten anmelden
	ballSpecialist = new RBallSpecialist(processor,*this);
	rip->setSpecialist(ballSpecialist);

  //den BallSpecialist beschrnken
	for (int i=0; i<2; i++)
		ballSpecialist->maximums[i] = MAX_BALL_PAIRS;

	//Das Raster konfigurieren
	int margin = 2;
	
	rip->marginX = margin;
	rip->marginY = margin;
	
	//Anzahl Pixel in Hhe und Breite
	rip->rasterHeight = rip->image.cameraInfo.resolutionHeight / rip->marginX;
	rip->rasterWidth  = rip->image.cameraInfo.resolutionWidth  / rip->marginY;
	
	int height = rip->rasterHeight;
	int width = rip->rasterWidth;

  //Hier ein gleichmssiges Raster mit 5 Punkt abstand.
	for (int x=0;x<width;x++)
		for (int y=0;y<height;y++)
		{
			rip->raster[x][y] = Vector2<int>(x*margin,y*margin);
			
		}	

  //OUTPUT(idText, text, "still alive!!");
}

REnemyStrategy::~REnemyStrategy()
{	
  delete ballSpecialist;
}

void REnemyStrategy::init()
{
	ballSpecialist->init();

	

}

void REnemyStrategy::execute()
{

	OUTPUT(idText,text,"there is no spoon.");
	int width = rip->rasterWidth;
	int height = rip->rasterHeight;
    int lastColor, currentColor;
	
  //Der PreScan
	//Ganz simples zeilenweises Abscannen
  for (int y=0; y<height; y++) {
  	lastColor    = noColor;
	  currentColor = noColor;
   //OUTPUT(idText,text,"next line:"<< y); 
    for(int x=0; x<width; x++){	
		currentColor = getColorFromRaster(x,y);
		
		//OUTPUT(idText,text,"color" << currentColor << " "<< x <<" "<< y);
			
		
			if ( ballSpecialist->preScanNeeded &&
				isFieldBallChange(currentColor,lastColor) || 
				x == width-1 && currentColor == orange ||
				x == 0 && currentColor == orange){
				
				ballSpecialist->invokeOnPreScan(x, y);
				DOT(imageProcessor_general, 
					getVecFromRaster(x,y).x,getVecFromRaster(x,y).y,
					Drawings::ps_solid, Drawings::pink);
				//OUTPUT(idText,text,"invoked : "<<x << " "<< y);
				//OUTPUT(idText,text,"inImage : "<<getVecFromRaster(x,y).x <<
				//	" "<< getVecFromRaster(x,y).y);
			}
			
			//mit getColorFromRaster() kann man sich die Farbe 
			//eines Pixels mit einem Table-Lookup
			//besorgen
		lastColor = currentColor;
	}
  }  
    
	//Der PostScan
	//Ganz simples spaltenweise Abscannen
	//Aber doch von unten nach oben!!!
  for (int x=0; x<width; x++) {
  	lastColor    = noColor;
	  currentColor = noColor;

    for(int y=height-1; y>=0; y--)
		{		
		
		currentColor = getColorFromRaster(x,y);
			
			//Wenn Wechsel von orange auf weiss,grau oder grn.
			if ( (ballSpecialist->postScanNeeded &&
				isFieldBallChange(currentColor, lastColor)) || 
				y == 0 && currentColor == orange||
				y == height-1 && currentColor == orange){
				ballSpecialist->invokeOnPostScan(x,y);
				DOT(imageProcessor_general, 
					getVecFromRaster(x,y).x,getVecFromRaster(x,y).y 
					, Drawings::ps_solid, Drawings::pink);
			}
			//mit getColorFromRaster() kann man sich die Farbe 
			//eines Pixels mit einem Table-Lookup
			//besorgen
			lastColor = currentColor;
		}
  }

   ballSpecialist->executePostProcessing();
}


/*
* Change log :
* 
* $Log: REnemyStrategy.cpp,v $
* Revision 1.5  2004/01/21 11:04:30  loetzsch
* removed some OUTPUTs
*
* Revision 1.4  2003/12/15 11:49:08  juengel
* Introduced CameraInfo
*
* Revision 1.3  2003/12/08 16:49:49  roefer
* signed/unsigned mismatch corrected
*
* Revision 1.2  2003/12/08 15:02:55  schmidtb
* new version of RIP
*
* Revision 1.1  2003/12/02 12:45:44  neubach
* new EnemySpecialist added
*
*
*
*/