// RFieldSpecialist.h: Schnittstelle fr die Klasse RFieldSpecialist.
//
//////////////////////////////////////////////////////////////////////

#ifndef RFIELDSPECIALIST_H
#define RFIELDSPECIALIST_H


#include "RasterSpecialist.h"
#include "RasterStrategy.h"
#include "Modules/ImageProcessor/ImageProcessorTools/MSH2004EdgeDetection.h"
#include "Modules/ImageProcessor/ImageProcessorTools/SegmentationTools.h"
#include "Representations/Perception/LinesPercept.h"


using namespace std;

class RFieldSpecialist :public RasterSpecialist  {

public:

	typedef slist<LinePair2> lstLinePair;
//	typedef slist<lineOnField> lstLineOnField;
	typedef slist<figure> lstFig;

	RFieldSpecialist(RasterImageProcessor &processor,RasterStrategy &strategy);
	virtual ~RFieldSpecialist();
	void invokeOnPostScan(int x, int y);
	void executePostProcessing();
	void invokeOnPreScan(int x,int y);
	virtual int getType();
	virtual void init();	


	void addLinePoint(LinesPercept::LineType, point &, int&);


private:
	
	enum goal_line {NONE = 0, YELLOW, SKYBLUE};

	struct processParam {
		unsigned int min_size;
		unsigned int step_alpha;
		unsigned int tol_alpha;

		processParam(): min_size(6), step_alpha(5),
			tol_alpha(20) {}
	};

	RasterStrategy *strategy;

	MSH2004EdgeDetection edgeScanner;

	lstFig lst_pts;

	point temp;
	LinesPercept::LineType lineInside;


	processParam* defaultParam, *preScanParam;

	inline int id(LinesPercept::LineType);
	inline LinesPercept::LineType id(int i) ;

	bool makeLines(lstFig&, lstLinePair&, const processParam*);

	vector <lstFig> segments_img;
	vector <lstLinePair> vecLines;

	void clearSegments();

	void fusionLines(lstLinePair& lst);

	unsigned int analyzeLines();


	//  0 : invalid

	//  1 :  \___    2 :  ___/   (outside the goal)

	//  3 :  /--     4 :  --\    (inside the goal)

	//  5 : ---                  (goalie line)
	
	//  6   --()--               (center line)

	//  7 : ---                  (simple line)

	void drawCross(goal_line g, point& v);
	void drawCircle(goal_line g, point& v);
	void drawLine(goal_line g, LinePair2& lp);

};

#endif

/*
* Change log :
* 
* $Log: RFieldSpecialist.h,v $
* Revision 1.26  2004/06/04 12:43:05  deom
* optimized
*
* Revision 1.25  2004/06/02 16:03:53  deom
* merged different versions of FieldSpecialist
*
* Revision 1.24  2004/05/27 16:49:47  deom
* new parameter set + some minor changes
*
* Revision 1.23  2004/05/22 19:03:40  deom
* -now recognizes the red line
* -all the data required for the positionning are computed
*
* Revision 1.17  2004/05/22 16:56:39  pg_dade
* -now recognizes the red line
* -all the data required for the positionning are computed
*
* Revision 1.16  2004/04/15 19:08:34  pg_besc
* merged code
*
* Revision 1.20  2004/03/29 15:25:16  deom
* - the basical segmentation tools are now fast completely debbuged.
* - seem to work pretty good now
* - somes parameters need to be tuned
*
* Revision 1.19  2004/03/23 15:50:26  deom
* now uses two scan methods
*
* Revision 1.18  2004/03/21 21:59:06  deom
* The new scan functions intergrated to RfieldSpecialist. The lines recognition works at 90%
*
* Revision 1.17  2004/03/20 10:47:28  roefer
* Don't check in files that do not compile.
* If you declare functions, implement them, too.
* Global functions implemented in header files must be declared inline.
*
* Revision 1.16  2004/03/19 22:06:49  deom
* now based on  the segmentationTools class
*
* Revision 1.15  2004/03/15 01:17:36  deom
* debugged, now recognizes all predetermined forms
*
* Revision 1.14  2004/03/14 12:51:58  deom
* added an accurate scan method
*
* Revision 1.13  2004/03/12 14:39:13  deom
* debugged
*
* Revision 1.12  2004/03/12 01:37:58  deom
* added some functions required for the lines analysis
*
* Revision 1.11  2004/03/11 19:21:01  deom
* pursued debugging and parametrisation
*
* Revision 1.10  2004/03/11 12:19:00  deom
* debbuged RFieldspecialist
*
* Revision 1.9  2004/03/01 14:17:25  koh
* added new strategy "RFlexibleStrategy" + new specialist "EnemyOnlySpecialist";
* changed references to "RDefaultStrategy" to references to "RasterStrategy" in RFieldSpecialist
* added Geometry::Line horizon to "RasterStrategy"
*
* Revision 1.8  2004/03/01 12:14:41  wachter
* Bug commented out.
*
* Revision 1.7  2004/02/29 20:06:16  deom
* detects complex lines ( but need to be debuged)
*
* Revision 1.6  2004/02/22 19:12:54  deom
* now recognize simple lines
*
* Revision 1.4  2004/02/16 05:00:48  deom
* basical version that show edges
*
* Revision 1.3  2003/12/15 13:55:32  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.2  2003/12/08 15:02:55  schmidtb
* new version of RIP
*
* Revision 1.1  2003/12/04 09:50:26  schmidtb
* Added RFieldSpecialist
*
* Revision 1.5  2003/12/02 21:59:02  schmidtb
* New version of RasterImageProcessor
*
* Revision 1.4  2003/11/28 14:50:01  dueffert
* bugs and warnings fixed
*
* Revision 1.3  2003/11/20 10:26:56  schmidtb
* Ball Detection added
*
* Revision 1.2  2003/11/13 10:41:29  schmidtb
* renewed RBallSpeciaslist and Strategy
*
* Revision 1.1  2003/11/12 13:13:20  schmidtb
* new RasterImageProcessor added
*
*
*/
