/**
 * @file RFlexibleStrategy.cpp
 * 
 * This file contains the implementation of RFlexibleStrategy.cpp for the RasterImageProcessor
 *
 * @author <a href="mailto:rookie_rocksta@web.de">Hyung-Won Koh</a>
 *
 *	only an idea, not final cause too inefficient yet
 */																									
//////////////////////////////////////////////////////////////////////

#include "RFlexibleStrategy.h"


//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

RFlexibleStrategy::RFlexibleStrategy(RasterImageProcessor &processor):
	RasterStrategy(processor),
	ballFactor(1),
	fieldFactor(2),
	playerFactor(1),
	goalFactor(1),
	lmFactor(1)
{		
	//Das Raster konfigurieren	
	rip->marginX = 2;
	rip->marginY = 2;
	
	//Anzahl Pixel in Hhe und Breite
	rip->rasterWidth  = rip->image.cameraInfo.resolutionWidth  / rip->marginX;
	rip->rasterHeight = rip->image.cameraInfo.resolutionHeight / rip->marginY;
	
	height = rip->rasterHeight;
	width = rip->rasterWidth;
	
	//set for-cycle-increment of raster[x][y] above, between and below horizon here
	//	not final, here and there correction missing!!(see for-cycles)
	yIncAbove	=	1;	 
	xIncAbove = 1;
	yIncBetween = 1;
	xIncUnderHor = 1;
	yIncBelow = 1;	
	xIncBelow = 1;

	if(yIncAbove==0||xIncAbove==0||yIncBetween==0||xIncUnderHor==0||yIncBelow==0||xIncBelow==0)
	{
		OUTPUT(idText,text,"Increment-Values in for-cycles invalid, set to default!!");	
		yIncAbove	=	1;	 
		xIncAbove = 1;
		yIncBetween = 1;
		xIncUnderHor = 1;
		yIncBelow = 1;	
		xIncBelow = 1;
	}
	
	//	calculate the value to substract from actual x for more precise results, prevent too many calculations in cycle
	lmCorAbove = (int)((lmFactor*xIncAbove)/2+0.4);

	playerCorBetween =(int) ((playerFactor*xIncUnderHor)/2+0.4);
	ballCorBetween = (int)((ballFactor*xIncUnderHor)/2+0.4);
	goalCorBetween = (int)((goalFactor*xIncUnderHor)/2+0.4);		//	has to be destinguished if above or under horizon(if different xInc will be enabled)
	lmCorBetween = (int)((lmFactor*xIncUnderHor)/2+0.4);	//	has to be destinguished if above or under horizon(if different xInc will be enabled)
	
	playerCorBelow =(int) ((playerFactor*xIncBelow)/2+0.4);
	ballCorBelow = (int)((ballFactor*xIncBelow)/2+0.4);
	goalCorBelow = (int)((goalFactor*xIncBelow)/2+0.4);
	lmCorBelow = (int)((lmFactor*xIncBelow)/2+0.4);
	
	fieldCorBelow = (int)((fieldFactor*xIncBelow)/2+0.4);

/*
	if(getPlayer().getTeamColor() == Player::red)
		{
		enemyColor = blue;
		teamColor = red;
		OUTPUT(idText,text,"enemycolor = blue!");	
		}
	else	if(getPlayer().getTeamColor() == Player::blue)
		{
		enemyColor = red;
		teamColor = blue;		
		OUTPUT(idText,text,"enemycolor = red");			
		}*/

	//set red enemy Color as default
	enemyColor = red;
	teamColor = blue;


  //einen neuen BallSpezialisten anmelden
	ballSpecialist = new RBallSpecialist(processor,*this);
	rip->setSpecialist(ballSpecialist);
	linePattern = green + white;	

  //den BallSpecialist beschrnken
  for (int i=0; i<2; i++)
  		ballSpecialist->maximums[i] = MAX_BALL_PAIRS;	
  
	enemyOnlySpecialist = new REnemyOnlySpecialist(processor,*this);
	rip->setSpecialist(enemyOnlySpecialist);

	fieldSpecialist = new RFieldSpecialist(processor,*this);
	rip->setSpecialist(fieldSpecialist);

	boxSpecialist = new BoxSpecialist(processor,*this);
	rip->setSpecialist(boxSpecialist);


	for (int x=0;x<width;x++)
		for (int y=0;y<height;y++)
		{
			rip->raster[x][y] = Vector2<int>(x*rip->marginX,y*rip->marginY);
			//isEdge[x][y] = false;
		}	
}

RFlexibleStrategy::~RFlexibleStrategy()
{	
  delete ballSpecialist;
  delete fieldSpecialist;
  delete enemyOnlySpecialist;
  delete boxSpecialist;

}

void RFlexibleStrategy::init()
{	
	ballSpecialist->init();
	fieldSpecialist->init(); 
	boxSpecialist->init();
  enemyOnlySpecialist->init();

	if (!rip->cameraMatrix.isValid)
		enemyOnlySpecialist->preScanNeeded = false;	
}

void RFlexibleStrategy::execute()
{		
	OUTPUT(idText,text,"Camera is valid: " << rip->cameraMatrix.isValid);
	
	horizon = rip->getHorizon(); 
	OUTPUT(idText,text,"h-base: " << horizon.base.x << " " << horizon.base.y);
	OUTPUT(idText,text,"h-direction" << horizon.direction.x <<" "<< horizon.direction.y);
	
	preScan();
	postScan();
	postProcessing();

}
/***
*		basic Idea of this strategy is to organize the scan, by treating often seen colors (like green) or important colors(orange)
*		for themselves to establish faster performance
*		not every Color is treatend yet, and not every color will be presented so often that extra treatment would be worthwhile
*/
void RFlexibleStrategy::preScan(){
	
  horizon = rip->getHorizon(); 
  Vector2<double> direction = horizon.direction;
  Vector2<double> base = horizon.base;	

	if( base.y >rip->marginY*height)	//	aibo guckt in die Luft
		return;


	double horX = 0; // is not initialized in any case: this might be an error!	
	double horAdd = 0; // is not initialized in any case: this might be an error!	

	leftBall = width;
	rightBall = 0;
	ballDepth = 0;
	horFalls = (direction.y > 0 && direction.x>0);
	horRises = (direction.y <0 && direction.x>0);
	horConst = (direction.y == 0);
	bool doBottomOnly = false;
	
	
	if(base.y <0)	//	aibo guckt nach unten, sollte noch verbessert werden auf Randwerte (nicht nur mitte!)
	{
		bottomHorY = 0;
		doBottomOnly = true;
	}
	else{
	if(horFalls)
	{
		topHorY = (int)	((base.y+0.5 - ((width/2* direction.x)*direction.y)) / rip->marginY);				//	left
		bottomHorY = (int) ((base.y+0.5 + ((width/2* direction.x)*direction.y)) / rip->marginY);	//	right		
		horX = 1;
		horAdd =	((yIncBetween/direction.y)*direction.x);	//	the int value to add to horX every line
	}
	else if(horRises)
	{
		topHorY = (int)	((base.y+0.5 + ((width/2* direction.x)*direction.y)) / rip->marginY);			//	right
		bottomHorY = (int) ((base.y +0.5- ((width/2* direction.x)*direction.y)) / rip->marginY);	//	left
		horX = width;
		horAdd =((yIncBetween/direction.y)*direction.x);	//	the int value to add to horX every line
	}
	else if(horConst)
	{
		topHorY = (int)base.y;
		bottomHorY = topHorY;
		horX =1;
		horAdd = 0;
	}
	if(topHorY <0)
	{
		if(bottomHorY <0)
		{
			horConst = true;		//just to exclude scanning the horizon-area
			bottomHorY = 0;
		}
		else
		{
			horX += (topHorY-1)*horAdd*(-1);		//	adjust start value; if horX > width, then bottomHor < 0, horX will never be called					
			if(horX <1)
				horX = 1;
			if(horX > width)
				horX = width;
		}
		topHorY = 0;
	}
	if(bottomHorY >height)
	{
		bottomHorY = height;
		if(topHorY > height)
			topHorY = height;
	}
	}

	if(!doBottomOnly)
	{
	/* scan the rectangle ABOVE the horizon***************************************************************/
	for(register int y1 = 0;y1 < topHorY;y1+=yIncAbove)
		{		
		DOT(imageProcessor_general, 1,rip->marginY*y1, Drawings::black, Drawings::white);		

  		lastColor    = noColor;
		currentColor = noColor;
		BoxColor = noColor;
		insideBox = false;
		insideField = false;
		insideLM = false;	
		for(register int x = 0; x < width; x+=xIncAbove)
		{
			currentColor = getColorFromRaster(x,y1);
			if ( y1%goalFactor==0 && x%goalFactor == 0 )
				checkBox(x,y1,0);
			lastColor = currentColor;
		}
		//	last Color of Line == Box-Color?
		if(insideBox)		
			boxSpecialist->invokeOnPreScan(width-lmCorAbove-1,y1);		
		}

	if(!horConst)
		{
	/*scan the HORIZON-AREA******************************************************************/
	for(register int y2 = topHorY; y2 < bottomHorY; y2+=yIncBetween)
		{		
		//Info
		DOT(imageProcessor_general, 1,rip->marginY *y2,
			Drawings::white, Drawings::black);

  	lastColor    = noColor;
		currentColor = noColor;
		BoxColor = noColor;
		insideBall = false;
		insideBox = false;
		insideField = false;
		insideLM = false;
		insidePlayer = false;
		whiteAgain = false;
		
		//	calculate x-Value of horizon
		if(horX<1)
			{	
			OUTPUT(idText,text,"horX < 1!");
			horX = 1;
			}
		if(horX > width)
			{
			horX = width;
			OUTPUT(idText,text,"horX >"<<width<<"!");
			}
		DOT(imageProcessor_general, rip->marginX*horX,rip->marginY*y2, 
			Drawings::white, Drawings::black);

		/*	Now scan horizon area, destinguish between < horX (left of horizon) and > horX(right of horizon)!*/

		if(horFalls)
		{
			for (register int x1 = 0; x1<= (int)horX; x1+=xIncUnderHor)
			{
				currentColor = getColorFromRaster(x1,y2);
				if(currentColor == green)
				{					
					if(insidePlayer)
					{
						enemyOnlySpecialist->invokeOnPreScan(x1,y2,enemyCtr);
						insidePlayer = false;
					}
					if(insideBall)
					{
						ballSpecialist->invokeOnPreScan(x1,y2);					
						insideBall = false;
					}
					if(insideBox)
					{
						boxSpecialist->invokeOnPreScan(x1,y2);
						insideBox = false;
					}
					whiteAgain = false;
					continue;
				}
				else if(currentColor == white)
				{
					if(whiteAgain)
						whiteCtr++;
					else
						whiteCtr = 1;
					if(insidePlayer && yPlayerFactor && xPlayerFactor && whiteCtr >2) //	if white sequence of 3 RasterPixel found (might be Border)
					{
						enemyOnlySpecialist->invokeOnPreScan(x1,y2,enemyCtr);
						insidePlayer = false;
					}					
					if(insideBall && yPlayerFactor && xPlayerFactor)
					{
						ballSpecialist->invokeOnPreScan(x1,y2);
						insideBall = false;
					}
					if(insideBox && yGoalFactor && xGoalFactor)
					{
						boxSpecialist->invokeOnPreScan(x1,y2);
						insideBox = false;
					}
					whiteAgain = true;
					continue;
				}
				else if(currentColor == orange  )
				{					
					whiteAgain = false;
					if(!insideBall && ballSpecialist->preScanNeeded /*&&(y2%ballFactor + x1%ballFactor == 0)*/)
					{
						ballSpecialist->invokeOnPreScan(x1,y2);
						insideBall = true;
					}
					
					if(insidePlayer)
					{
						enemyOnlySpecialist->invokeOnPreScan(x1,y2,enemyCtr);
						insidePlayer = false;
					}
					if(insideBox)
					{
						boxSpecialist->invokeOnPreScan(x1,y2);
						insideBox = false;
					}
					continue;
				}
				else			//	other color
				{										
					whiteAgain = false;
					if(insideBall)
					{
						ballSpecialist->invokeOnPreScan(x1,y2);	
						insideBall = false;
					}
					if (enemyOnlySpecialist->preScanNeeded)
						checkPlayer(x1,y2);
					if (x1%goalFactor + y2%goalFactor == 0)
						checkBox(x1,y2,0);
				}
				lastColor = currentColor;
			}

			//	horizon arrived here, boolean insidePlayer /~Ball not used till end of line
			if(insidePlayer)
			{
				enemyOnlySpecialist->invokeOnPreScan((int)horX,y2,enemyCtr);								
			}
			if(insideBall)
			{
				ballSpecialist->invokeOnPreScan((int)horX,y2);
			}

			//	now scan the rest of the line
			for(register int x2 =(int)horX+1; x2 < width; x2+=xIncUnderHor)
			{								
				currentColor = getColorFromRaster(x2,y2);
				if (x2%goalFactor + y2%goalFactor == 0)
						checkBox(x2,y2,0);				
			lastColor = currentColor;
			}

			//	end of line arrived, scan last Points on Line
			if(currentColor==green)
				checkLastLinePoint(fieldFactor,currentColor,y2,(RasterSpecialist&) *(fieldSpecialist));
				
			if(insideBox)
				boxSpecialist->invokeOnPreScan(width-1,y2);
		}
		else			//	!horFalls ~ Horizont steigt  /
		{
			for(register int x1 = 0; x1< (int)horX; x1+=xIncUnderHor)
			{
				currentColor = getColorFromRaster(x1,y2);
				if (x1%goalFactor + y2%goalFactor == 0)
					checkBox(x1,y2,0);
			}
			for(register int x2 = (int)horX; x2<width; x2+=xIncUnderHor)
			{
				currentColor = getColorFromRaster(x2,y2);
				if(currentColor == green)
				{
					if(insidePlayer)
					{
						enemyOnlySpecialist->invokeOnPreScan(x2,y2,enemyCtr);
						insidePlayer = false;
					}
					if(insideBall)
					{
						ballSpecialist->invokeOnPreScan(x2,y2);		
						insideBall = false;
					}
					if(insideBox)
					{
						boxSpecialist->invokeOnPreScan(x2,y2);
						insideBox = false;
					}					
					whiteAgain = false;
					continue;
				}				
				else if(currentColor == white)
				{
					if(whiteAgain)
						whiteCtr++;
					else
						whiteCtr = 1;
					if(insidePlayer && yPlayerFactor && xPlayerFactor && whiteCtr >2) //	if white sequence over 4 RasterPixel found (might be Border)
					{
						enemyOnlySpecialist->invokeOnPreScan(x2,y2,enemyCtr);
						insidePlayer = false;
					}					
					if(insideBall && yPlayerFactor && xPlayerFactor)
					{
						ballSpecialist->invokeOnPreScan(x2,y2);
						insideBall = false;
					}
					if(insideBox && yGoalFactor && xGoalFactor)
					{
						boxSpecialist->invokeOnPreScan(x2,y2);
						insideBox = false;
					}					
					whiteAgain = true;
					continue;
				}
				else if(currentColor == orange  )
				{					
					whiteAgain = false;

					if(!insideBall && ballSpecialist->preScanNeeded &&(y2%ballFactor + x2%ballFactor == 0))
					{
						ballSpecialist->invokeOnPreScan(x2,y2);
						insideBall = true;
					}

					if(insidePlayer)
					{
						enemyOnlySpecialist->invokeOnPreScan(x2,y2,enemyCtr);
						insidePlayer = false;
					}
					if(insideBox)
					{
						boxSpecialist->invokeOnPreScan(x2,y2);
						insideBox = false;
					}
					continue;
				}
				else	//	check Points on ScanLine for any other color
				{
					whiteAgain = false;
					if (enemyOnlySpecialist->preScanNeeded)
						checkPlayerRisingHor(x2,y2);
					if (x2%goalFactor + y2%goalFactor == 0)
						checkBox(x2,y2,0);					
					if(insideBall && ballSpecialist->preScanNeeded &&(y2%ballFactor + x2%ballFactor == 0))
					{
						ballSpecialist->invokeOnPreScan(x2,y2);	
						insideBall = false;
					}
				}
			}			
			//	end of Line arrived here, scan last Point on Line y2
			if(currentColor == green)	
				checkLastLinePoint(fieldFactor,currentColor,y2,(RasterSpecialist&) *(fieldSpecialist));
			if(insidePlayer)
				enemyOnlySpecialist->invokeOnPreScan(width-playerCorBetween-1,y2,enemyCtr);
			if(insideBall)
				ballSpecialist->invokeOnPreScan(width-ballCorBetween-1,y2);		
			if(insideBox)
				boxSpecialist->invokeOnPreScan(width-lmCorBetween-1,y2);			
		}
		
		horX += horAdd;	//	calculate next horizon point
		}
		}
		}
	
	
	/*scan the rectangle UNDER the horizon area***********************************************************/


	for(register int y3 = bottomHorY; y3 < height; y3+=yIncBelow)
		{
		yPlayerFactor = ((y3/yIncBelow)%playerFactor == 0);
		yBallFactor = ((y3/yIncBelow)%ballFactor ==0);
		yGoalFactor = ((y3/yIncBelow)%goalFactor ==0);
		yLmFactor = ((y3/yIncBelow)%lmFactor ==0);
		yFieldFactor = ((y3/yIncBelow)%fieldFactor ==0);

		DOT(imageProcessor_general, 0,rip->marginY*y3, 
			Drawings::black, Drawings::white);

  	lastColor    = noColor;
		currentColor = noColor;
		BoxColor = noColor;
		insideBall = false;
		insideBox = false;
		insideField = false;
		insideLM = false;
		insidePlayer = false;
		orangeAgain = false;
		leftBallTested = false;
		inRedBall = false;
		whiteAgain = false;
		//orangeCtr = 0;

		for(register int x = 0; x < width; x+=xIncBelow)
		{
			xPlayerFactor = ((x/xIncBelow)%playerFactor==0);
			xBallFactor = ((x/xIncBelow)%ballFactor==0);
			xGoalFactor = ((x/xIncBelow)%goalFactor==0);
			xLmFactor = ((x/xIncBelow)%lmFactor==0);
			xFieldFactor = ((x/xIncBelow)%fieldFactor==0);
			currentColor = getColorFromRaster(x,y3);
			if(currentColor == green)
			{
				if(insidePlayer && yPlayerFactor && xPlayerFactor)
				{
					enemyOnlySpecialist->invokeOnPreScan(x-playerCorBelow,y3,enemyCtr);
					insidePlayer = false;
				}
				if(insideBall && yBallFactor && xBallFactor)
				{
					ballSpecialist->invokeOnPreScan(x-ballCorBelow,y3);
					if(leftBallTested)
						rightBall = x;
					insideBall = false;
				}
				if(insideBox && yGoalFactor && xGoalFactor)
				{
					boxSpecialist->invokeOnPreScan(x,y3);
					insideBox = false;
				}				
				orangeAgain = false;
				whiteAgain = false;
				continue;
			}
				else if(currentColor == white)
				{
					if(whiteAgain)
						whiteCtr++;
					else
						whiteCtr = 1;
					if(insidePlayer && yPlayerFactor && xPlayerFactor && whiteCtr >4) //	if white sequence of 5 RasterPixel found (might be Border)
					{
						enemyOnlySpecialist->invokeOnPreScan(x,y3,enemyCtr);
						insidePlayer = false;
					}					
					if(insideBall && yPlayerFactor && xPlayerFactor)
					{
						ballSpecialist->invokeOnPreScan(x,y3);
						if(leftBallTested)
							rightBall = x;						
						insideBall = false;
					}
					if(insideBox && yGoalFactor && xGoalFactor)
					{
						boxSpecialist->invokeOnPreScan(x,y3);
						insideBox = false;
					}
					whiteAgain = true;
					continue;
				}
			else if(currentColor == orange )				
			{
				if(orangeAgain)
					orangeCtr++;
				else
					orangeCtr =1;				
				if(!leftBallTested && orangeCtr ==3 )
				{
					leftBall = x-(orangeCtr*xIncBelow+1);
					leftBallTested = true;
					ballDepth = y3;
					OUTPUT(idText, text, "left of Ball = "<< leftBall);
					DOT(imageProcessor_general, leftBall*rip->marginX, y3*rip->marginY, 
						Drawings::white, Drawings::orange);
				}
				if(!insideBall && yBallFactor && xBallFactor && ballSpecialist->preScanNeeded )
				{
					ballSpecialist->invokeOnPreScan(x,y3);
					insideBall = true;
				}
				if( insidePlayer && xPlayerFactor )	//	 try to exclude Lp of red segmented actual orange Ball pixel
				{
					if(enemyColor == red && leftBallTested) 
					{
						if( x > leftBall && x < rightBall)
						{
							insidePlayer = false;
						}					
						else
						{
							enemyOnlySpecialist->invokeOnPreScan(x-playerCorBelow,y3,enemyCtr);
							insidePlayer = false;
						}
					}
					else	//	blue enemys or no orangeBall
					{
						enemyOnlySpecialist->invokeOnPreScan(x-playerCorBelow,y3,enemyCtr);
						insidePlayer = false;
					}
				}
				if(insideBox && xGoalFactor)
				{
					boxSpecialist->invokeOnPreScan(x,y3);
					insideBox = false;
				}
				orangeAgain = true;
				whiteAgain = false;
				continue;
			}
			else		//	if currentColor = any other Color
			{
				whiteAgain = false;
				if (yGoalFactor && xGoalFactor)
					checkBox(x,y3,0);

				if(insideBall && xBallFactor)
				{
					ballSpecialist->invokeOnPreScan(x-xBallFactor,y3);				
					if(leftBallTested)
						rightBall = x + xIncBelow;	//	border!!
					insideBall = false;
				}				
				//	exclude Lp inside red segmented Ball, do not enemyOnlySpecialist->invokeOnPreScan!
				if(		(orangeAgain && x > leftBall && (currentColor == red || currentColor == black || currentColor == gray)) 
					||	(y3<= ballDepth+rightBall - leftBall)&& x >=leftBall && x <= rightBall	)
				{
					inRedBall = true;
					insidePlayer = false;
					continue;
				}
				 else if(inRedBall)
				{
					if(!(currentColor == red || currentColor == orange) || x > rightBall)
						inRedBall = false;
					else					
						continue;
				}
				else if (enemyOnlySpecialist->preScanNeeded)
					checkPlayer(x,y3);
				orangeAgain = false;
			}
		}
		
		//	end of Line arrived here, scan last Point on Line y2
		if(currentColor == green && yFieldFactor)
			fieldSpecialist->invokeOnPreScan(width-fieldCorBelow-1, y3);
		if(insidePlayer && yPlayerFactor)		
			enemyOnlySpecialist->invokeOnPreScan(width-playerCorBelow-1,y3,enemyCtr);			
		if(insideBall && yBallFactor)
		{
			ballSpecialist->invokeOnPreScan(width-ballCorBelow-1,y3);
			if(leftBallTested)
				rightBall = width-1;
		}
		if(insideBox && yGoalFactor)
			boxSpecialist->invokeOnPreScan(width-goalCorBelow-1,y3);	
		lastColor = currentColor;
		if(leftBallTested)
			DOT(imageProcessor_general, rightBall*rip->marginX, y3*rip->marginY, 
				Drawings::white, Drawings::yellow);
		}		
}
		
			
void RFlexibleStrategy::checkPlayer(int x,int y){	
	
	if (!insidePlayer){
		bool isNewPoint = (currentColor == black || currentColor == enemyColor || currentColor == gray);	
		if (isNewPoint){
			enemyCtr = 0;
			whiteCtr=0;
			enemyOnlySpecialist->invokeOnPreScan(x,y,0);
			insidePlayer = true;
		}
	}
	else	//	insidePlayer == true;
	{		
		//	if currentColor == green || orange, enemyOnlySpecialist->invokeOnPreScan(...) directly called!
		bool isClosingPoint = (currentColor == teamColor || currentColor == skyblue || currentColor == yellow );
		if (isClosingPoint)
		{
			enemyOnlySpecialist->invokeOnPreScan(x,y, enemyCtr);
			insidePlayer = false;
		}
		else if(currentColor == enemyColor)
		{
			enemyCtr++;
		}		
		else if(enemyCtr ==0 && currentColor == white)
		{
			whiteCtr++;
			if(whiteCtr >3)
				insidePlayer = false;
		}			
	}
}

void RFlexibleStrategy::checkPlayerRisingHor(int x,int y){
	if (!insidePlayer){
		bool isNewPoint = (currentColor == black || currentColor == enemyColor || currentColor == gray);	
		if (isNewPoint){
			enemyCtr = 0;
			//tolerance = 0;
			//whiteCtr = 0;
			enemyOnlySpecialist->invokeOnPreScan(x,y,0);
			insidePlayer = true;
		}
	}
	else
	{
		bool isClosingPoint = (currentColor == teamColor || currentColor == yellow || currentColor == skyblue);
		if (isClosingPoint)
		{
			enemyOnlySpecialist->invokeOnPreScan(x,y, enemyCtr);
			insidePlayer = false;
		}
		else if(currentColor == enemyColor)
		{
			enemyCtr++;
		}
		else if(enemyCtr ==0 && currentColor == white)
		{
			whiteCtr++;
			if(whiteCtr >3)
				insidePlayer = false;
		}		
	}
}



void RFlexibleStrategy::postScan(){ 
	
	//Der PostScan
	//Ganz simples spaltenweise Abscannen
	//Aber doch von unten nach oben!!!
  for (int x=0; x<width; x++) {
  	lastColor    = noColor;
	currentColor = noColor;
	insideBall = false;
	insideBox = false;
	insideField = false;
	insideLM = false;

    for(int y=height-1; y>=0; y--)
		{				
		currentColor = getColorFromRaster(x,y);		
		//if (fieldSpecialist->postScanNeeded && (y%fieldFactor + x%fieldFactor == 0))
		//    checkField(x,y,1);

		if (ballSpecialist->postScanNeeded && (y%ballFactor + x%ballFactor == 0))
			checkBall(x,y,1);

		//if ((y%goalFactor + x%goalFactor == 0))
		//	checkGoal(x,y,1);			
		lastColor = currentColor;
	}
	checkLastColumnPoint(ballFactor,orange,x,(RasterSpecialist&) *(ballSpecialist));
  }
}


void RFlexibleStrategy::postProcessing(){	
	ballSpecialist->executePostProcessing();
	// fieldSpecialist->executePostProcessing();
	 enemyOnlySpecialist->executePostProcessing();
	 //boxSpecialist->executePostProcessing();
}



void RFlexibleStrategy::checkBall(int x,int y,int prePost){
	bool isNewPoint = currentColor == orange;	
	if (!insideBall){
		if (isNewPoint){
			if (prePost == 0) ballSpecialist->invokeOnPreScan(x,y);
			else ballSpecialist->invokeOnPostScan(x,y);
			insideBall = true;
		}
	}
	else if (!isNewPoint){
		if (prePost == 0) ballSpecialist->invokeOnPreScan(x-ballFactor,y);
		else ballSpecialist->invokeOnPostScan(x,y+ballFactor);
		insideBall = false;
	}

/*	if (!insideBall){
		if (isNewPoint){
			ballSpecialist->in(x,y);
			insideBall = true;
		}
	}
	else if (!isNewPoint){
		ballSpecialist->out(x-ballFactor,y);
		insideBall = false;
	}
*/
}

void RFlexibleStrategy::checkField(int x,int y,int prePost){

	bool isNewPoint;

	isNewPoint = (currentColor == green);

	if (!insideField){
		if (isNewPoint){
			if (prePost == 0) fieldSpecialist->invokeOnPreScan(x,y);
			else fieldSpecialist->invokeOnPostScan(x,y);
			insideField = true;
		}
	}
	else if(!isNewPoint){
		if (prePost == 0) fieldSpecialist->invokeOnPreScan(x-fieldFactor,y);
		else fieldSpecialist->invokeOnPostScan(x,y+fieldFactor);
		insideField = false;
	}
}


void RFlexibleStrategy::checkBox(int x, int y,int prePost){

	bool newBoxPoint;

	
	newBoxPoint = (currentColor == yellow || currentColor == skyblue || currentColor == pink);


	if(!insideBox) {
		if (newBoxPoint) {

			boxSpecialist->invokeOnPreScan(x,y);			
			BoxColor = currentColor;
			insideBox = true;
		}
	}
	else if(currentColor!=BoxColor){

		boxSpecialist->invokeOnPreScan(x-goalFactor,y);
		BoxColor = noColor;
		insideBox = false;
	} 
	
}

void RFlexibleStrategy::checkLastLinePoint(int factor,colorClass color,
										  int line,RasterSpecialist &spec){
		if (color == getColorFromRaster(width - width%factor -1 ,line))
			spec.invokeOnPreScan(width - width%factor - 1 ,line);
}

void RFlexibleStrategy::checkLastColumnPoint(int factor,colorClass color,
											int column,RasterSpecialist &spec){
		if(color == getColorFromRaster(column,height%factor))
			spec.invokeOnPostScan(column,height%factor);
}

/**Searches for Line on the image*/
void RFlexibleStrategy::checkLine(int x,int y){
	Vector2<int> v = getVecFromRaster(x,y);

	if (v.y < 1 || v.y > 174) return;
	int c2x =  v.x+0;
	int c2y =  v.y+2;
	int c3x =  v.x-0;
	int c3y =  v.y-2;


	int c1[3] = {
		rip->image.image[v.y][0][v.x], 
		rip->image.image[v.y][1][v.x],  
		rip->image.image[v.y][2][v.x]};
	int c2[3] = {
		rip->image.image[c2y][0][c2x],  
		rip->image.image[c2y][1][c2x],  
		rip->image.image[c2y][2][c2x]};
	int c3[3] = {
	    rip->image.image[c3y][0][c3x], 
		rip->image.image[c3y][1][c3x],
		rip->image.image[c3y][2][c3x]};


	int diff1 =(c1[0] + c1[1]) - (c2[0] + c2[1]);  
	
	int diff2 =(c1[0] + c1[1]) - (c3[0] + c3[1]);
	
	//int mult = (c1[0] - c1[2]) - (2*c2[0] - c2[2]);
	if(diff1 > 25 || diff2 > 25){							
		DOT(imageProcessor_general, v.x, v.y, 
		Drawings::red, Drawings::red);
	//	isEdge[x][y] = true;
	}
	//else isEdge[x][y] = false;

	/*if(mult >0){							
		DOT(imageProcessor_general, v.x, v.y, 
		Drawings::green, Drawings::green);
		isEdge[x][y] = true;
	}*/
}



/*
* Change log :
* 
* $Log: RFlexibleStrategy.cpp,v $
* Revision 1.6  2004/03/17 16:55:03  koh
* some minor changes
*
* Revision 1.5  2004/03/02 13:14:22  roefer
* Warnings and errors removed
*
* Revision 1.4  2004/03/01 20:58:42  koh
* new strategy RFlexibleStrategy and new RasterSpecialist REnemyOnlySpecialist added
*
*
* commit log added
*
*
*/

