#ifndef RGOALSPECIALIST_H
#define RGOALSPECIALIST_H


#include "RasterSpecialist.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Math/Vector2.h"
#include "RDefaultStrategy.h"
#include <list>
#include <vector>

using namespace std;

/*
struct SegmentInfo {
	Vector2<int> maxHor;
	Vector2<int> minHor;
	Vector2<int> maxPHor;
	Vector2<int> minPHor;
};

struct Rectangle {
	Vector2<double> upperLeft;
	Vector2<double> upperRight;
	Vector2<double> bottomLeft;
	Vector2<double> bottomRight;
};

*/


class RGoalSpecialist :public RasterSpecialist

{
public:
	RGoalSpecialist(RasterImageProcessor &processor,RasterStrategy &strategy);
	virtual ~RGoalSpecialist();
	void invokeOnPostScan(int x, int y);
	void executePostProcessing();
	void invokeOnPreScan(int x,int y);
	virtual int getType();
	virtual void init();

private:

	RasterStrategy *strategy;


	std::list<LinePair> lst_pts;
	unsigned int c;
	Geometry::Line horizon;
	Geometry::Line pHorizon;


	Vector2 <int> left_border;
	
	double getDistanceToLine
	(
		const Geometry::Line line,
		const Vector2<int>& point
	);

	void createInfos(std::vector<list<LinePair> >& v, std::list<SegmentInfo>& infos);
	

	void createRectangles(std::list<SegmentInfo>& infos,std::vector<Rectangle>& rects);
	void calculateValidities(std::list<SegmentInfo>& rects);
	
	/**Merge the second segment in the first. Second one can
		be deletet after the merge;*/
	void mergeSegments(SegmentInfo& seg1,SegmentInfo& seg2);

};

#endif


/*
* Change Log:
*
* $Log: RGoalSpecialist.h,v $
* Revision 1.11  2004/01/26 20:37:56  schmidtb
* removed errors and warnings, merged versions of RGoalSpecialist
*
* Revision 1.10  2004/01/23 15:44:01  deom
* New specialist :: BoxSpecialist
* Recognizes both landmarks and goals
*
* Revision 1.9  2004/01/20 17:11:44  deom
* no message
*
* Revision 1.8  2004/01/19 16:18:45  schmidtb
* GoalSpecialist recognizes Landmarks
*
* Revision 1.7  2004/01/16 17:22:49  deom
* no message
*
* Revision 1.6  2004/01/13 14:12:12  deom
* no message
*
* Revision 1.5  2003/12/18 10:56:17  deom
* no message
*
* Revision 1.4  2003/12/16 21:48:10  deom
* *** empty log message ***
*
* Revision 1.3  2003/12/15 13:55:32  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.2  2003/12/11 17:27:56  loetzsch
* did not compile
*
*/
