/**
* @file DefaultLEDControl.h
* 
* This file contains a class for LED Control.
*/

#ifndef __DefaultLEDControl_h_
#define __DefaultLEDControl_h_

#include "LEDControl.h"

/** the standard GT2002 LED control module */
class DefaultLEDControl : public LEDControl
{
public:
/*
* Constructor.
* @param interfaces The paramters of the LEDControl module.
  */
  DefaultLEDControl(const LEDControlInterfaces& interfaces);

  /** Executes the module. */
  virtual void execute();
  
private:
  /** Internal call counter. */
  int executeCallCount; 
  void executeERS210();
  void executeERS7();
};

#endif// __DefaultLEDControl_h_

/*
 * Change log :
 * 
 * $Log: DefaultLEDControl.h,v $
 * Revision 1.3  2004/03/08 01:39:02  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2004/02/28 00:00:39  wachter
 * LED-Requests are now useful on the ERS7.
 *
 * Revision 1.1  2003/10/06 14:10:14  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/09/11 20:06:19  loetzsch
 * continued experiments with modules/solutions
 *
 * Revision 1.1  2002/09/10 15:36:15  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/05/25 22:52:19  roefer
 * WLan, first working approach
 *
 * Revision 1.2  2002/05/16 22:36:11  roefer
 * Team communication and GTMath bugs fixed
 *
 * Revision 1.4  2002/05/04 17:47:44  loetzsch
 * LEDControl now has access to an instance of WLanStatus
 * (which shall be displayed then with the green leds. follows next)
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
