/**
* @file LEDControlSelector.h
* 
* Definition of class LEDControlSelector
*
* @author Matthias Jngel
*/

#ifndef __LEDControlSelector_h_
#define __LEDControlSelector_h_

#include "Tools/Module/ModuleSelector.h"
#include "DefaultLEDControl.h"
#include "ATH2004LEDControl.h"

/**
* LEDControl selection module.
*
* A selector for LED control modules.
*/
class LEDControlSelector : public ModuleSelector, public LEDControlInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the LEDControl module.
  */
  LEDControlSelector(ModuleHandler &handler,const LEDControlInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::ledControl),
    LEDControlInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::ledControl,this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::ath2004LEDControl: 
      return new ATH2004LEDControl(*this);
      
    case SolutionRequest::defaultLEDControl: 
      return new DefaultLEDControl(*this);

    default:
      return 0;
    }
  }
};

#endif // __LEDControlSelector_h_

/*
* Change log :
* 
* $Log: LEDControlSelector.h,v $
* Revision 1.1  2004/03/20 17:16:13  juengel
* no message
*
*/
