/**
* @file DebugMotionControl.h
*
* Definition of class DebugMotionControl.
* 
* @author Max Risler
*/

#ifndef __DebugMotionControl_h_
#define __DebugMotionControl_h_

#include "MotionStabilizer.h"
#include "breathe.h"
#include "MotionControl.h"
#include "Tools/Actorics/JointDataSequencer.h"

/**
* @class DebugMotionControl
*
* A MotionControl module for debugging purposes.
*
* It ignores MotionRequest but processes and executes
* JointDataSequence debug messages.
* 
* @author Max Risler
*/
class DebugMotionControl : public MotionControl, public MotionStabilizer, public Breathe
{
public:
/** 
* Constructor 
* @param interfaces The paramters of the MotionControl module.
  */
  DebugMotionControl(const MotionControlInterfaces& interfaces)
    : MotionControl(interfaces)
  {}
  
  /** Executes the module */
  virtual void execute();
  
  /** 
  * Called from a MessageQueue to distribute messages.
  * Use message.getMessageID to decide if the message is relavant for 
  * the MesssageHandler derivate.
  * Use message.bin, message.text or message.config as In streams to get the data from.
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
  
protected:
  
  /** the JointDataSequencer */
  JointDataSequencer sequencer;
  
  /** write sensorData back to jointData for joints with invalidValue
  * to disable any motion (=stay as forced)
  */
  void executeStayAsForced(
    const SensorData& sensorData,
    JointData& jointData
    );
  
  void setStayAsForcedValue(
    const SensorData& sensorData,
    JointData& jointData,
    SensorData::sensors sensor,
    JointData::JointID joint,
    long tolerance
    );
  
  /** old values for stay as forced mode */
  JointData stayAsForcedOldValue;

  /** Clips the set joint values to allowed values */
  void clip();
};

#endif// __DebugMotionControl_h_

/*
* Change log :
* 
* $Log: DebugMotionControl.h,v $
* Revision 1.3  2004/03/08 01:39:02  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/07 16:59:19  loetzsch
* added a clipping function
*
* Revision 1.1  2003/10/06 14:10:13  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 11:38:52  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.6  2002/11/26 13:08:05  jhoffman
* no message
*
* Revision 1.5  2002/11/25 14:49:07  jhoffman
* added "breathing" motion
*
* Revision 1.4  2002/11/19 17:14:14  risler
* coding conventions: renamed JointData::joint to JointID, GetName to getName
*
* Revision 1.3  2002/11/19 15:43:03  dueffert
* doxygen comments corrected
*
* Revision 1.2  2002/09/11 00:06:58  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:15  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.3  2002/08/22 14:41:04  risler
* added some doxygen comments
*
* Revision 1.2  2002/07/23 13:33:41  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.5  2002/04/05 14:08:43  jhoffman
* stabilizer stuff
*
* Revision 1.4  2002/02/21 16:29:21  risler
* added JointDataSequencer
*
* Revision 1.3  2002/02/08 22:31:46  risler
* added JointDataSequence, finished DebugMotionControl
*
* Revision 1.2  2002/02/08 20:22:26  risler
* added DebugMotionControl
*
* Revision 1.1  2002/02/08 20:00:01  risler
* added DebugMotionControl
*
*/
