/**
* @file breathe.cpp
* 
* Implementation of class breathe
*
* @author Jan Hoffmann
*/

#include "breathe.h"
#include "Tools/Math/Common.h"
#include <math.h>


Breathe::Breathe() : 
time(0), durationOfOneBreath(100.0), absoluteAmplitude(120000.0), currentAmplitude(0.0)
{
}

bool Breathe::breathingMotion(
  const MotionRequest& motionRequest, 
  JointData& jointData)
{
  /* the following is used to ease in and out of the 
  * motion when it is switched on/off
  */
  if (!motionRequest.breathe)
  {
    if (currentAmplitude == 0) return false;
    if (currentAmplitude > 0)
      currentAmplitude -= 10000.0;
    time = 0;
  }
  else if (currentAmplitude < absoluteAmplitude)
    currentAmplitude += 1000.0;

  time++;

  long additionalJointMovement  = (long)(currentAmplitude - currentAmplitude * sin(time/durationOfOneBreath));
  long additionalJointMovement2  = (long)(currentAmplitude - .5*currentAmplitude * sin(pi + time/durationOfOneBreath));

  /* fore legs, knee joint */
  jointData.data[JointData::legFR1]  -= (long ) additionalJointMovement2;
  jointData.data[JointData::legFR3]  -= (long ) additionalJointMovement; 
  jointData.data[JointData::legFL1]  -= (long ) additionalJointMovement2; 
  jointData.data[JointData::legFL3]  -= (long ) additionalJointMovement; 

//jointData.data[JointData::legHR1]  += (long ) additionalJointMovement;
  jointData.data[JointData::legHR3]  += (long ) additionalJointMovement; 
//jointData.data[JointData::legHL1]  += (long ) additionalJointMovement; 
  jointData.data[JointData::legHL3]  += (long ) additionalJointMovement; 

  int i;
  long parkinson = 20000;

  for (i = JointData::legFR1; i < JointData::legHL3; i++)
    jointData.data[i] += (rand()%1000*(parkinson/1000) - parkinson/2);

  return true;
}


/*
 * Change log :
 * 
 * $Log: breathe.cpp,v $
 * Revision 1.1  2003/10/06 14:10:13  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2002/11/26 17:18:13  risler
 * breathing only when standing is executed (not requested)
 *
 * Revision 1.3  2002/11/26 13:08:05  jhoffman
 * no message
 *
 * Revision 1.2  2002/11/25 17:21:00  jhoffman
 * no message
 *
 * Revision 1.1  2002/11/25 14:53:24  jhoffman
 * added breathing motion
 *
 *
 *
 *
 */
