/**
* @file breathe.h
* 
* Definition of class breathe
*
* @author Jan Hoffmann
*/

#ifndef __Breathe_h_
#define __Breathe_h_

#include "Modules/WalkingEngine/WalkingEngine.h"


/**
* @class Breathe
* This class adds a breathing motion to other movements
* @author Jan Hoffmann
*/
class Breathe
{
public:

  Breathe();

  /**
  * takes all parameters...
  * 
  * @param motionRequest
  * @param jointData
  * 
  * @return true if successfull
  */ 
  bool breathingMotion(
    const MotionRequest& motionRequest, 
    JointData& jointData);
  
private:
  double time;
  double durationOfOneBreath;
  double absoluteAmplitude;
  double currentAmplitude;

};

#endif// __breathe_h_

/*
 * Change log :
 * 
 * $Log: breathe.h,v $
 * Revision 1.1  2003/10/06 14:10:13  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2002/12/16 13:45:51  dueffert
 * doxygen docu corrected
 *
 * Revision 1.3  2002/12/05 16:13:56  dueffert
 * doxygen docu added
 *
 * Revision 1.2  2002/11/26 13:08:05  jhoffman
 * no message
 *
 * Revision 1.1  2002/11/25 14:53:24  jhoffman
 * added breathing motion
 *
 *
 *
 *
 */
