/**
 * @file GO2003PlayersLocator.h
 * 
 * This file contains a class for players localization.
 * @author <A href=mailto:mkunz@informatik.uni-bremen.de>Michael Kunz</A>
 */

#ifndef __GO2003PlayersLocator_h_
#define __GO2003PlayersLocator_h_

#include "PlayersLocator.h"
#include "VAPoints.h"
#include "Representations/Motion/OdometryData.h"

/**
 * This class is a locator for players of the own and the opponents team.
 * It can assign the detected percepts to the players (even if they are not seen for two seconds),
 * using points with validity and age.
 *
 * @author <a href=mailto:mkunz@sim.tu-darmstadt.de>Michael Kunz</a>
 */
class GO2003PlayersLocator : public PlayersLocator
{

public:
  static const double TEAM_MESSAGE_VALIDITY, MIN_MATCH_DIST;

  /** Constants for the number of robots in the own and in the opponents team*/
  enum {NUMBER_OF_OWN_PLAYERS_TO_LOCATE=3, NUMBER_OF_OPPONENT_PLAYERS_TO_LOCATE=4};

  enum {NUMBER_OF_POINTS_FOR_OWN_PLAYERS=150, NUMBER_OF_POINTS_FOR_OPPONENT_PLAYERS=200};

  /** 
  * Constructor.
  * @param interfaces The paramters of the PlayersLocator module.
  */
  GO2003PlayersLocator(const PlayersLocatorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

private:

  TeamMessage teamMessage[NUMBER_OF_OWN_PLAYERS_TO_LOCATE];

  /** 
   * The points with validity and age for determining the position of robots 
   * of the own team 
   */
  VAPoints opponentPointsWithValidityAndAge;
  /**
   * The points with validity and age for determining the position of robots 
   * of the opponents team 
   */
  VAPoints ownPointsWithValidityAndAge;

  /**
   * Corrects the position of players. When the calculated position of a robot lies outside
   * the playingfiled it is corrected to the nearby groundline.
   * @param oldX The x position before correcting it
   * @param oldY The y position before correcting it
   * @param newX The corrected x position
   * @param newY The corrected y position
   * @return Returns TRUE if position is corrected, otherwise FALSE
   */
  bool correctObstaclePosition(int oldX, int oldY, int &newX, int &newY);

  void addOwnPlayerPercepts(
    const SinglePlayerPercept playerPercepts[],
    int numberOfPlayerPercepts,
    const RobotPose& startRobotPose,
    const double collectionValidity,
    const unsigned long collectionTimestamp);

  void addOppPlayerPercepts(
    const SinglePlayerPercept playerPercepts[],
    int numberOfPlayerPercepts,
    const RobotPose& startRobotPose,
    const double collectionValidity,
    const unsigned long collectionTimestamp);

};

#endif// __GO2003PlayersLocator_h_

/*
 * Change log :
 * 
 * $Log: GO2003PlayersLocator.h,v $
 * Revision 1.2  2004/03/08 01:07:16  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/06 14:10:15  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/09/26 15:27:49  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.2  2003/09/26 11:38:52  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.8  2003/05/27 12:48:12  mkunz
 * no more needed constants removed
 *
 * Revision 1.7  2003/05/20 12:39:44  mkunz
 * less points
 *
 * Revision 1.6  2003/05/16 14:50:13  mkunz
 * more points again
 *
 * Revision 1.5  2003/05/14 13:19:57  mkunz
 * bigger reorganization
 *
 * Revision 1.4  2003/05/13 14:31:16  mkunz
 * full transfer toVAPoints
 *
 * Revision 1.3  2003/05/08 19:51:23  mkunz
 * switched to VAPoints
 *
 * Revision 1.2  2003/04/15 15:52:09  risler
 * DDD GO 2003 code integrated
 *
 * Revision 1.6  2003/04/13 05:44:47  dthomas
 * modified: removed many features because nothing really works ;-(
 * added: alternative headcontrol
 *
 * Revision 1.5  2003/04/13 02:41:56  dthomas
 * modified: raised queue size
 *
 * Revision 1.4  2003/04/12 17:01:27  mkunz
 * back again
 *
 * Revision 1.3  2003/03/31 18:17:43  max
 * tamara update
 *
 * Revision 1.1  2003/03/29 12:51:03  mkunz
 * just a copy of GT2001
 *
 *
 */
