/**
* @file RobotStateDetectorSelector.h
* 
* Definition of class RobotStateDetectorSelector
*
* @author Max Risler
* @author Martin Ltzsch
* @author Matthias Jngel
*/

#ifndef __RobotStateDetectorSelector_h_
#define __RobotStateDetectorSelector_h_

#include "Tools/Module/ModuleSelector.h"
#include "DefaultRobotStateDetector.h"

/**
* RobotStateDetector selection module.
*
* A selector for robot state selectors
*/
class RobotStateDetectorSelector : public ModuleSelector, public RobotStateDetectorInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the RobotStateDetector module.
  */
  RobotStateDetectorSelector(ModuleHandler &handler, const RobotStateDetectorInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::robotStateDetector),
    RobotStateDetectorInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::robotStateDetector, this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::defaultRobotStateDetector:
      return new DefaultRobotStateDetector(*this);
    default:
      return 0;
    }
  }
};

#endif // RobotStateDetectorSelector_h_

/*
* Change log:
*
* $Log: RobotStateDetectorSelector.h,v $
* Revision 1.3  2004/03/08 02:11:45  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2002/09/12 09:45:58  juengel
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:15  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/05/14 12:39:04  dueffert
* corrected some documentation mistakes
*
* Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.2  2002/03/28 16:55:58  risler
* RobotStateDetector receives BodyPercept instead of PerceptCollection
* added switch duration in RobotStateDetector
*
* Revision 1.1  2002/02/05 03:52:16  loetzsch
* added a few new module selectors
*
*/
