/**
* @file Modules/SelfLocator/NoOdometrySelfLocator.h
* 
* This file contains a class for self-localization based on SingleLandmarks w/o odometry.
* @author <a href="mailto:spranger@informatik.hu-berlin.de">Michael Spranger</a>
*
*/

#ifndef __NoOdometrySelfLocator_h_
#define __NoOdometrySelfLocator_h_

#include "SelfLocator.h"
#include "Tools/Debugging/GenericDebugData.h"
#include "Tools/Player.h"

/**
* Class for self-localization based on SingleLandmarks without odometry
*/
class NoOdometrySelfLocator : public SelfLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SelfLocator module.
  */
  NoOdometrySelfLocator(const SelfLocatorInterfaces& interfaces);
  
  /**
  * Destructor.
  */
  ~NoOdometrySelfLocator() {}
  
  /** Executes the module */
  virtual void execute();

  /** movement per frame */
  double speed;

  /** debugflags */
  int debugflags;
  int debugframes;

  /** Called from a MessageQueue to distribute messages. */
  bool handleMessage(InMessage&);
  /*	
	Pose2D referencePose;
  */
  int refGoalFramenr;
	int refGoalvalid;
	Goal referenceGoal;


	unsigned long int timeOfLastExecute;
 
};

#endif// __NoOdometrySelfLocator_h_

/*
* Change log :
* 
* $Log: NoOdometrySelfLocator.h,v $
* Revision 1.4  2004/03/08 02:11:48  roefer
* Interfaces should be const
*
* Revision 1.3  2003/12/18 11:48:45  spranger
* added support for seeing 2 goals and some mor debugmessage handling
*
* Revision 1.2  2003/12/03 21:03:44  spranger
* added DebugMessageHandling (handleMessage)
*
* Revision 1.1  2003/12/02 19:18:21  spranger
* added NoOdometrySelfLocator
*
*
*/
