/**
* @file AlLx_RemotePresence.cpp
* Description...
* 
* @author <a href="mailto:urban@informatik.hu-berlin.de">Alexander Urban</a>
*/

#include "AlLx_RemotePresence.h"


In& operator>>(In& stream, AlLx_CommPacket& p) {

	int
		command, i;

	stream >> command;
	p.command = (AlLx_CommPacket::Commands) command;

	for (i = 0; i < 5; i++)
		stream >> p.parameter[i];

	return stream;
}

Out& operator<<(Out& stream, AlLx_CommPacket& p) {

	int
		command, i;

	command = (int) p.command; 
	stream << command;

	for (i = 0; i < 5; i++)
		stream << p.parameter[i];

	return stream;
}


AlLx_RemotePresence::AlLx_RemotePresence(const SensorBehaviorControlInterfaces& interfaces)
						: SensorBehaviorControl(interfaces) {

	speed = 30;
	motion = AlLx_CommPacket::stopMotion;
}

void AlLx_RemotePresence::init() {

}

void AlLx_RemotePresence::execute() {

	headControlMode.headControlMode = HeadControlMode::lookStraightAhead;

	motionRequest.motionType = MotionRequest::walk;
	motionRequest.walkType = MotionRequest::normal;

	/* Note: maximum speed is 200 */
	if (motion == (int) AlLx_CommPacket::goForward)
		motionRequest.walkParams.translation.x = speed;
	else if (motion == (int) AlLx_CommPacket::goBackward)
		motionRequest.walkParams.translation.x = -speed;
	else
		motionRequest.walkParams.translation.x = 0;

	motionRequest.walkParams.translation.y = 0;

	/* Note: maximum rotation speed is pi/2 (per sec)*/
	if (motion == (int) AlLx_CommPacket::turnLeft)
		motionRequest.walkParams.rotation = (speed / 200.0) * 1.5;
	else if (motion == (int) AlLx_CommPacket::turnRight)
		motionRequest.walkParams.rotation = (speed / 200.0) * -1.5;
	else
		motionRequest.walkParams.rotation = 0;
}

bool AlLx_RemotePresence::handleMessage(InMessage& message) {

	if (message.getMessageID() != idAlLxComm)
		return false;

	AlLx_CommPacket
		acp;
	message.bin >> acp;

	switch (acp.command) {
	case AlLx_CommPacket::setSpeed:
		speed = (int) acp.parameter[0];
		break;

	case AlLx_CommPacket::goForward:
	case AlLx_CommPacket::goBackward:
	case AlLx_CommPacket::turnLeft:
	case AlLx_CommPacket::turnRight:
	case AlLx_CommPacket::stopMotion:
		motion = (int) acp.command;
		break;

	}

	return true;
}

/*
* Change log :
* 
* $Log: AlLx_RemotePresence.cpp,v $
* Revision 1.2  2004/03/08 02:11:49  roefer
* Interfaces should be const
*
* Revision 1.1  2003/11/17 14:56:04  urban
* added SensorBehaviorControl-solution "AlLx RemotePresence" and RobotControl-dialogbar "AlLx Joystick"
*
*
*/
