/**
* @file AlLx_RemotePresence.h
* Description...
* 
* @author <a href=mailto:urban@informatik.hu-berlin.de>Alexander Urban</a>
*/
 
#ifndef __ALLX_REMOTEPRESENCE_H__
#define __ALLX_REMOTEPRESENCE_H__

#include "Tools/Streams/InOut.h"
#include "Tools/MessageQueue/MessageIDs.h"

#include "SensorBehaviorControl.h"

/**
* Description...
*/
struct AlLx_CommPacket {

	enum Commands {
		setSpeed = 0,
		goForward,
		goBackward,
		turnLeft,
		turnRight,
		stopMotion,
		numberOfCommands
	};

	int
		command;
	double
		parameter[5];
};

/**
 * Streaming operator that reads AlLx_CommPacket from a stream.
 * @param stream The stream from which is read.
 * @param p The AlLx_CommPacket object.
 * @return The stream.
 */ 
In& operator>>(In& stream, AlLx_CommPacket& p);
 
/**
 * Streaming operator that writes AlLx_CommPacket to a stream.
 * @param stream The stream to write on.
 * @param p The AlLx_CommPacket object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, AlLx_CommPacket& p);


/**
* Description...
*/
class AlLx_RemotePresence : public SensorBehaviorControl {

public:

	/** 
	* Constructor.
	* @param interfaces The paramters of the SensorBehaviorControl module.
	*/
	AlLx_RemotePresence(const SensorBehaviorControlInterfaces& interfaces);

	/** some init's that are only done when the module is called
	* for the first time (or if it hasn't been called for a while) 
	* such as setting the headcontrol-mode
	*/
	void init();

	/** the "main" module where all the magic is happening */
	virtual void execute();

	/**  */
	virtual bool handleMessage(InMessage& message);

private:
	int
		speed, motion;
};

#endif	// __ALLX_REMOTEPRESENCE_H__

/*
* Change log :
* 
* $Log: AlLx_RemotePresence.h,v $
* Revision 1.2  2004/03/08 02:11:49  roefer
* Interfaces should be const
*
* Revision 1.1  2003/11/17 14:56:04  urban
* added SensorBehaviorControl-solution "AlLx RemotePresence" and RobotControl-dialogbar "AlLx Joystick"
*
*
*/
