/**
* @file ObstacleAvoiderOnGreenFieldERS7.h
* Class that generates Motion requests in a fashion similar to the ObstacleAvoiderOnGreenFieldERS7 ve.
* 
* @author <A href=mailto:jhoffman@informatik.hu-berlin.de>Jan Hoffmann</A>
*/
 
#ifndef __ObstacleAvoiderOnGreenFieldERS7_h_
#define __ObstacleAvoiderOnGreenFieldERS7_h_

#include "SensorBehaviorControl.h"
#include "Tools/Math/PIDsmoothedValue.h"
#include "Tools/Debugging/DebugImages.h"
#include "Tools/Debugging/DebugDrawings.h"


/**
* Class that generates Motion requests in a fashion similar to the Braitenberg but also uses
* the PSD sensor to not run into things.
*/
class ObstacleAvoiderOnGreenFieldERS7 : public SensorBehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SensorBehaviorControl module.
  */
  ObstacleAvoiderOnGreenFieldERS7(const SensorBehaviorControlInterfaces& interfaces);
  
  /** some init's that are only done when the module is called
  * for the first time (or it it hasn't been called for a while) 
  * such as setting the headcontrol-mode
  */
  void init();
  /** the "main" module where all the magic is happening */
  virtual void execute();
  /** calibrate the psd (while standing still) to the minimum 
  * value it measures */
  void calibrate();
  /** currently no debug messages are handled */
  virtual bool handleMessage(InMessage& message);

private:
  double maxSpeedX, distanceToGround, distanceOffset, distanceControlInterval;
  PIDsmoothedValue speedX, speedY, speedPhi;
  int gridSize, greenOrLight;
  unsigned long timeOfLastExecute, timeToCalibrate;
	ColorTable64 localColTable;
	bool localColTableInitialized;

  // images for debugging
  DECLARE_DEBUG_IMAGE(classificationY);
};

#endif// __ObstacleAvoiderOnGreenFieldERS7_h_

/*
* Change log :
* 
*/
