/**
* @file SensorBehaviorControl.h
* This file contains a generic class for Modules which generate
* motionRequests by sensorData.
* 
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/

#ifndef __SensorBehaviorControl_h_
#define __SensorBehaviorControl_h_

#include "Tools/Module/Module.h"

#include "Representations/Perception/Image.h"
#include "Representations/Perception/SensorDataBuffer.h"
#include "Representations/Perception/CameraMatrix.h"
#include "Representations/Perception/ColorTable.h"
#include "Representations/Perception/ColorTable64.h"
#include "Representations/Sound/SoundRequest.h"
#include "Representations/Motion/MotionRequest.h"
#include "Representations/Motion/LEDRequest.h"
#include "Representations/Motion/HeadControlMode.h"
#include "Representations/Motion/OdometryData.h"
#include "Representations/Cognition/RobotState.h"

/**
* @class SensorBehaviorControlInterfaces
* 
* The interfaces of the SensorBehaviorControl module.
*/
class SensorBehaviorControlInterfaces
{
public:
  /** Constructor.*/
  SensorBehaviorControlInterfaces(
    const Image& image,
    const SensorDataBuffer& sensorDataBuffer,
    const CameraMatrix& cameraMatrix,
    const ColorTable& colorTable,
    const OdometryData& odometryData,
    const RobotState& robotState,
    SoundRequest& soundRequest,
    MotionRequest& motionRequest,
    LEDRequest& ledRequest,
    HeadControlMode& headControlMode
    )
    : 
    image(image),
    sensorDataBuffer(sensorDataBuffer),
    cameraMatrix(cameraMatrix),
    colorTable(colorTable),
    odometryData(odometryData),
		robotState(robotState),
    soundRequest(soundRequest),
    motionRequest(motionRequest),
    ledRequest(ledRequest),
    headControlMode(headControlMode)
  {}
  
  /**  */
  const Image& image;
  
  /**  */
  const SensorDataBuffer& sensorDataBuffer;

  /**  */
  const CameraMatrix& cameraMatrix;

  /** The color table ptr */ 
  const ColorTable& colorTable;
  
  /** The odometry that was estimated by the motion modules */
  const OdometryData& odometryData;

	/** */
  const RobotState& robotState;

  /**  */
  SoundRequest& soundRequest;

  /**  */
  MotionRequest& motionRequest;
  
  /**  */
  LEDRequest& ledRequest;
  
  /**  */
  HeadControlMode& headControlMode;
};

/**
* A generic class for Modules which generate
* motionRequests by sensorData.
* 
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/
class SensorBehaviorControl : public Module, public SensorBehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the SensorBehaviorControl module.
  */
  SensorBehaviorControl(const SensorBehaviorControlInterfaces& interfaces)
    : SensorBehaviorControlInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~SensorBehaviorControl() {}
};

#endif //__SensorBehaviorControl_h_

/*
 * Change log :
 * 
 * $Log: SensorBehaviorControl.h,v $
 * Revision 1.3  2004/03/08 02:11:50  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2003/12/09 16:28:15  jhoffman
 * - added sounds to obstacle avoider on green field
 * - added calibration mode for obstacle avoider on green field
 *
 * Revision 1.1  2003/10/06 14:10:15  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:27:49  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.9  2003/05/02 18:15:18  risler
 * SensorDataBuffer added
 * replaced SensorData with SensorDataBuffer
 * full SensorData resolution now accessible
 *
 * Revision 1.8  2003/03/06 11:51:39  dueffert
 * re-order warning removed
 *
 * Revision 1.7  2003/02/21 18:32:04  roefer
 * pColorTable -> colorTable finished
 *
 * Revision 1.6  2003/02/18 21:29:17  osterhues
 * Changed all instances of ColorTable64 to new base class ColorTable
 *
 * Revision 1.5  2003/01/13 18:25:30  juengel
 * Added odometry to SensorBehaviorControlInterfaces.
 *
 * Revision 1.4  2002/12/06 16:41:01  goehring
 * no message
 *
 * Revision 1.3  2002/11/28 18:53:13  juengel
 * SoundRequest zu den interfaces hinzugefgt
 *
 * Revision 1.2  2002/11/20 15:44:49  juengel
 * Added cameraMatrix to SensorBehaviorControlInterfaces.
 *
 * Revision 1.1  2002/11/07 17:27:58  loetzsch
 * renamed Module SensorDataToMotionRequest to SensorBehaviorControl
 *
 * Revision 1.2  2002/09/12 12:24:09  juengel
 * continued change of module/solution mechanisms
 *
 * Revision 1.1  2002/09/10 15:36:16  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/08/22 14:41:03  risler
 * added some doxygen comments
 *
 * Revision 1.2  2002/07/29 17:44:48  jhoffman
 * added braitenberg vehicle-style behavior (or actually: a "sensor data to motion request")
 *
 * Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/01/06 13:48:33  juengel
 * WalkDemo hinzuefgt.
 *
 *
 */
