/**
* @file SimpleMotionRecognition.h
*
* Definition of class SimpleMotionRecognition
*
* @author <a href="mailto:ordyniak@informatik.hu-berlin.de">Sebastian Ordyniak</a>
* @author <a href="mailto:richert@informatik.hu-berlin.de">Marten Richert</a>
*/

#ifndef __SimpleMotionRecognition_h_
#define __SimpleMotionRecognition_h_

#include "Modules/SensorBehaviorControl/SensorBehaviorControl.h"
#include "Tools/Debugging/DebugDrawings.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Debugging/DebugImages.h"
#include "Tools/Actorics/RobotDimensions.h"

#define SIMPLEIMAGEBUFFERSIZE 3
#define MINDIFF 30
#define WAITCONST 28 
#define WAITMIN 17
#define SPEEDFAKTOR Vector2<int>(2,1)
#define RESETCONST 40

/**
* @class SimpleMotionRecognition
*
* @author <a href="mailto:ordyniak@informatik.hu-berlin.de">Sebastian Ordyniak</a>
* @author <a href="mailto:richert@informatik.hu-berlin.de">Marten Richert</a>
*/ 

class SimpleMotionRecognition : public SensorBehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SimpleMotionRecognition module.
  */
  SimpleMotionRecognition(const SensorBehaviorControlInterfaces& interfaces);


  int searchTilt();
  int searchPan();
  bool headIsNotInMotion();
  Vector2<long> getAngleYZ(Vector2<int> point);
  Vector2<int> *getMotion();

  /** Executes the module */
  virtual void execute();
  virtual bool handleMessage(InMessage& message);

private:
	CameraMatrix previousCameraMatrix;
	Image imageBuffer[SIMPLEIMAGEBUFFERSIZE];
	int start, currentImage, imagesLeft, wait, reset, frameDiff,searchStatus,
		halfCameraResolutionHeigth, halfCameraResolutionWidth;
	double	halfCameraOpeningAngleHeigth, halfCameraOpeningAngleWidth;
	Vector2<int> *motion;
	Vector2<long> newHeadPos;
};
#endif// __SimpleMotionRecognition_h_

/*
* Change log :
* 
* $Log: SimpleMotionRecognition.h,v $
* Revision 1.5  2004/03/08 02:11:51  roefer
* Interfaces should be const
*
* Revision 1.4  2004/01/13 02:17:01  richert
* finetuning SimpleMotionDetector
*
* Revision 1.3  2004/01/09 20:09:50  richert
* some improovements
*
* Revision 1.2  2004/01/08 22:01:26  richert
* warning removed
*
* Revision 1.1  2004/01/08 21:51:40  richert
* beginning of "old" SimpleMotionRecognition
*
*/
