/**
* @file MovementData.cpp
*
* Implementation of class MovementData
*
* @author <a href="mailto:ordyniak@informatik.hu-berlin.de">Sebastian Ordyniak</a>
* @author <a href="mailto:richert@informatik.hu-berlin.de">Marten Richert</a>
*/

#include "MovementData.h"

MovementData::MovementData() {
}

void MovementData::setData(int _frameidx1,int _frameidx2, double tx, double ty, double tz, double rx, double ry, double rz) {
	frameidx1 = _frameidx1;
	frameidx2 = _frameidx2;
	t = Vector3<double>(tx,ty,tz);
	r = Vector3<double>(rx,ry,rz);
}

int MovementData::getFrameIdx1() {
	return frameidx1;
}

int MovementData::getFrameIdx2() {
	return frameidx2;
}

Vector3<double> MovementData::getCameraTranslation() {
	return t;
}

Vector3<double> MovementData::getCameraRotation() {
	return r;
}


int MovementData::isFrame(int fidx1, int fidx2) {
	if (fidx1 == frameidx1 && fidx2 == frameidx2)
		return 1;
	return 0;
}


/*
* Change log :
* 
* $Log: MovementData.cpp,v $
* Revision 1.1  2004/03/23 22:50:08  ordyniak
* no message
*
*/
