/**
* @file MovementData.h
*
* Definition of class MovementData
*
* @author <a href="mailto:ordyniak@informatik.hu-berlin.de">Sebastian Ordyniak</a>
* @author <a href="mailto:richert@informatik.hu-berlin.de">Marten Richert</a>
*/

#ifndef __MovementData_h_
#define __MovementData_h_

#include "Tools/Math/Geometry.h"

/**
* @class MovementData
*
* @author <a href="mailto:ordyniak@informatik.hu-berlin.de">Sebastian Ordyniak</a>
* @author <a href="mailto:richert@informatik.hu-berlin.de">Marten Richert</a>
*/ 

class MovementData
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the MovementData module.
  */
  MovementData();

  void setData(int _frameidx1,int _frameidx2, double tx, double ty, double tz, double rx, double ry, double rz);
  int getFrameIdx1();
  int getFrameIdx2();
  Vector3<double> getCameraTranslation();
  Vector3<double> getCameraRotation();
  int isFrame(int fidx1, int fidx2);

private:
	int frameidx1;
	int frameidx2;
	Vector3<double> t;
	Vector3<double> r;

};
#endif// __MovementData_h_

/*
* Change log :
* 
* $Log: MovementData.h,v $
* Revision 1.1  2004/03/23 22:50:08  ordyniak
* no message
*
*/
