/**
* @file SoundControl.h
* 
* Implementation of class SoundControl.
*
* @author <a href="mailto:Oliver.Giese@uni-dortmund.de">Oliver Giese</a>
* @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
*/

#ifndef __SoundControl_h_
#define __SoundControl_h_

#include "Tools/Module/Module.h"

#include "Representations/Sound/SoundRequest.h"
#include "Representations/Sound/SoundData.h"

/**
* @class SoundControlInterfaces
* 
* Interfaces of the SoundControl module.
*/
class SoundControlInterfaces
{
public:
  /** Constructor */
  SoundControlInterfaces(const SoundRequest& soundRequest, 
    SoundData& soundData)
    : soundRequest(soundRequest),
    soundData(soundData)
  {};
protected:  
  /** A request from the behavior control to play a specific sound */
  const SoundRequest& soundRequest; 
  
  /** The sound data to be generated */
  SoundData& soundData;
};

/**
* @class SoundControl
*
* A generic class for SoundControl modules.
*
* SoundControl is responsible for generating audio data.
*/
class SoundControl : public Module, public SoundControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the SoundControl module.
  */
  SoundControl(const SoundControlInterfaces& interfaces)
    : SoundControlInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~SoundControl() {}
};

#endif //__SoundControl_h_

/*
* Change log :
* 
* $Log: SoundControl.h,v $
* Revision 1.2  2004/03/08 02:11:52  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:27:49  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2002/09/12 13:17:27  loetzsch
* made member variables of module interfaces protected
*
* Revision 1.3  2002/09/11 20:06:19  loetzsch
* continued experiments with modules/solutions
*
* Revision 1.2  2002/09/11 00:06:58  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:16  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.5  2002/07/23 13:33:43  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.4  2002/05/27 15:39:04  fischer
* Added SoundState (Sender and Receiver)
*
* Revision 1.3  2002/05/15 07:28:18  hebbel
* Removed mute, uses Soundprotocol instead, plays wave for patternchallenge
*
* Revision 1.2  2002/05/14 18:52:58  hebbel
* Added variable mute
*
* Revision 1.1.1.1  2002/05/10 12:40:16  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.1  2002/04/28 19:14:12  giese
* SoundPlay added...
*
*
* 
*/
