/**
* @file GT2003MotionNetSpecialActions/MotionNetData.cpp
*
* Implementation of class MotionNetData
*
* @author Uwe Dffert, Martin Ltzsch, Max Risler
*/

#include "MotionNetData.h"
#include "Platform/GTAssert.h"

MotionNetData::MotionNetData()
: nodeArray(0)
{
}

void MotionNetData::load(In& stream)
{
  int i,j;
  
  for (i=0;i<MotionRequest::numOfSpecialAction;i++)
  {
    stream >> label_extern_start[i];
  }
  
  int numberOfNodes;
  
  
  stream >> numberOfNodes;

  if (nodeArray != 0) delete nodeArray;
  
  nodeArray = new MotionNetNode[numberOfNodes];
  short s;
  
  for (i=0;i<numberOfNodes;i++)
  {
    stream >> s;
    
    switch (s)
    {
    case 2:
      nodeArray[i].d[0] = (short)MotionNetNode::typeTransition;
      stream >> nodeArray[i].d[1] >> nodeArray[i].d[23];
      break;
    case 1:
      nodeArray[i].d[0] = (short)MotionNetNode::typeConditionalTransition;
      stream >> nodeArray[i].d[1] >> nodeArray[i].d[2] >> nodeArray[i].d[23];
      break;
    case 3:
      nodeArray[i].d[0] = (short)MotionNetNode::typeData;
      for (j=1;j<24;j++) stream >> nodeArray[i].d[j];
      break;
    case 4:
      nodeArray[i].d[0] = (short)MotionNetNode::typePID;
      for (j=1;j<5;j++) stream >> nodeArray[i].d[j];
      stream >> nodeArray[i].d[23];
      break;
    }
  }
}

MotionNetData::~MotionNetData()
{
  if (nodeArray != 0) delete nodeArray;
}

/** 
* Change Log:
*
* $Log: MotionNetData.cpp,v $
* Revision 1.1  2003/12/16 19:01:18  loetzsch
* The motion net is not compiled into a C++ file but parsed at run time.
*
*/
