/** 
* @file SpecialVision.h
* 
* Definition of class SpecialVision
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Juengel</A>
* @author Martin Ltzsch
*/

#ifndef __SpecialVision_h_
#define __SpecialVision_h_

#include "Tools/Module/Module.h"

#include "Representations/Perception/Image.h"
#include "Representations/Perception/SpecialPercept.h"
#include "Representations/Perception/SpecialVisionRequest.h"
#include "Representations/Perception/ColorTable.h"

/** 
* @class SpecialVisionInterfaces
* 
* The interfaces of the module SpecialVision
*/
class SpecialVisionInterfaces
{
public:
  /** Constructor */
  SpecialVisionInterfaces(const Image& image, 
    const SpecialVisionRequest& specialVisionRequest,
    const ColorTable& colorTable,
    SpecialPercept& specialPercept)
    : image(image),
    specialVisionRequest(specialVisionRequest),
    colorTable(colorTable),
    specialPercept(specialPercept)
  {}
protected:
  /** The image to be processed */
  const Image& image;
  
  /** A request from the behavior what to do */
  const SpecialVisionRequest& specialVisionRequest;
  
  /** A colortable ptr that can be used */
  const ColorTable& colorTable;

  /** The special percept to be generated */
  SpecialPercept& specialPercept;
};


/**
* @class SpecialVision
*
* The base class for special vision modules 
*/
class SpecialVision : public Module, public SpecialVisionInterfaces
{
public:
/** 
* Constructor
* @param interfaces The interfaces of the SpecialVision module 
  */
  SpecialVision(const SpecialVisionInterfaces& interfaces)
    : SpecialVisionInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~SpecialVision() {}
};

#endif // __SpecialVision_h_

/*
* Change log :
* 
* $Log: SpecialVision.h,v $
* Revision 1.2  2004/03/08 02:11:53  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/06 14:10:13  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:27:48  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/02/21 18:32:04  roefer
* pColorTable -> colorTable finished
*
* Revision 1.4  2003/02/18 21:29:17  osterhues
* Changed all instances of ColorTable64 to new base class ColorTable
*
* Revision 1.3  2002/11/19 15:43:03  dueffert
* doxygen comments corrected
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/10 15:36:16  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.3  2002/07/23 13:33:40  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.2  2002/06/02 23:21:09  roefer
* Single color table and progress in LinesSelfLocator
*
* Revision 1.1  2002/05/10 17:40:26  juengel
* Added SpecialVision and SpecialPercept.
*
*/
