/**
 * @file DefaultTeamBallLocator.h
 * 
 * Implementation of class DefaultTeamBallLocator.
 *
 * @author <a href="mailto:roefer@tzi.de">Thomas Rfer</a>
 * @author Martin Ltzsch
 */

#ifndef __DefaultTeamBallLocator_h_
#define __DefaultTeamBallLocator_h_

#include "TeamBallLocator.h"

#include "Tools/RingBuffer.h"

/**
* @class DefaultTeamBallLocator
*
* A simple solution of the TeamBallLocator module.
*
* @author <a href="mailto:roefer@tzi.de">Thomas Rfer</a>
* @author Martin Ltzsch
*/
class DefaultTeamBallLocator : public TeamBallLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the TeamBallLocator module.
  */
  DefaultTeamBallLocator(const TeamBallLocatorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();
};

#endif// __DefaultTeamBallLocator_h_

/*
 * Change log :
 * 
 * $Log: DefaultTeamBallLocator.h,v $
 * Revision 1.2  2004/03/08 02:11:53  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/06 14:10:14  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/05/01 17:09:08  loetzsch
 * Redesign of ball modeling:
 * - Modularized class BallPosition
 * - splitted up module "BallLocator" into "BallLocator" for modeling of percepts
 *   and "TeamBallLocator" for modelling communicated positions
 * - Removed solution JumpingBallLocator
 * - Splitted Solution DefaultBallLocator into DefaultBallLocator and DefaultTeamBallLocator
 * - Renamed SensorFusionBallLocator to GaussBellTeamBallLocator
 *
 */
