/**
* @file TeamBallLocator.h
* 
* Interfaces and definition of class TeamBallLocator.
*
* @author Martin Ltzsch
*/

#ifndef __TeamBallLocator_h_
#define __TeamBallLocator_h_

#include "Tools/Module/Module.h"

#include "Representations/Cognition/BallModel.h"
#include "Representations/Cognition/RobotPose.h"
#include "Representations/WLan/TeamMessageCollection.h"
#include "Representations/Motion/OdometryData.h"

/**
* @class TeamBallLocatorInterfaces
* 
* The interfaces of the TeamBallLocator module.
*/
class TeamBallLocatorInterfaces
{
public:
  /** Constructor.*/
  TeamBallLocatorInterfaces(
    const SeenBallPosition& seenBallPosition,
    const OdometryData& odometryData,
    const RobotPose& robotPose,
    const TeamMessageCollection& teamMessageCollection,
    CommunicatedBallPosition& communicatedBallPosition)
    : 
  seenBallPosition(seenBallPosition),
    odometryData(odometryData),
    robotPose(robotPose),
    teamMessageCollection(teamMessageCollection),
    communicatedBallPosition(communicatedBallPosition)
  {}
  
  /** The position of the seen ball */
  const SeenBallPosition& seenBallPosition;

  /** The odometry data provided by the motion modules */
  const OdometryData& odometryData;
  
  /** The robots position that was calculated last */
  const RobotPose& robotPose;
  
  /** Incoming team messages from other robots */ 
  const TeamMessageCollection& teamMessageCollection;
  
  /** The communicated ball position to be calculated by the module */
  CommunicatedBallPosition& communicatedBallPosition;
};

/**
* @class TeamBallLocator 
*
* The Base class for team ball locators
*
* It's task is to integrate ball measurements made by teammates.
*/
class TeamBallLocator : public Module, public TeamBallLocatorInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the TeamBallLocator module.
  */
  TeamBallLocator(const TeamBallLocatorInterfaces& interfaces)
    : TeamBallLocatorInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~TeamBallLocator() {}
};

#endif //__TeamBallLocator_h_

/*
* Change log :
* 
* $Log: TeamBallLocator.h,v $
* Revision 1.3  2004/03/08 02:11:54  roefer
* Interfaces should be const
*
* Revision 1.2  2004/02/03 13:19:50  spranger
* renamed all references to  class BallPosition to BallModel
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:27:49  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/01 17:09:08  loetzsch
* Redesign of ball modeling:
* - Modularized class BallPosition
* - splitted up module "BallLocator" into "BallLocator" for modeling of percepts
*   and "TeamBallLocator" for modelling communicated positions
* - Removed solution JumpingBallLocator
* - Splitted Solution DefaultBallLocator into DefaultBallLocator and DefaultTeamBallLocator
* - Renamed SensorFusionBallLocator to GaussBellTeamBallLocator
*
*/
