/**
* @file InvKinWalkingParameterSets.h
* 
* This file contains different 
* parameter sets for the
* InvKinWalkingEngine
*
* @author Max Risler
*/

/**
 *   ______________________
 *  / MSH2004 CONFIDENTIAL \
 *  \      DON'T CHECK IN! /
 *   ----------------------
 *      \   ^__^
 *       \  (oo)\_______
 *          (__)\       )\/\
 *              ||----w |
 *              ||     ||
 */

#ifndef __InvKinWalkingParametersSets_h_
#define __InvKinWalkingParametersSets_h_

#include "InvKinWalkingParameters.h"

/**
* @class QuickUNSWWalkingParameters
* Parameters for InvKinWalkingEngine 
* @author Jan Hoffmann
*
* UNSW with higher frequency for quicker and smoother
* motions, not necessarily faster in forward mode but 
* definitely faster in turning and sideways motions. 
* OPTIMIZE AT WILL!
*/
class QuickUNSWWalkingParameters : public InvKinWalkingParameters
{
public:
  QuickUNSWWalkingParameters() : InvKinWalkingParameters(
    "QuickUNSWClone",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    //old kinematics:61.522046, 70.900000, 45.635928,
    76.9, 78.1+5, 55.9,
    //hindHeight,hindWidth,hindCenterX
    //old kinematics:95.742519, 72.600000, -49.733089,
    108.6, 76.9+5, -56.1,
    //foreFootLift,hindFootLift
    //old kinematics:5.000000, 27.000000, 
    5.0, 24.0,
    //foreFootTilt,hindFootTilt
    //old kinematics:0.161686, -0.148314, 
    -0.06, 0.05,
    //legSpeedFactorX/Y/R
    1.1, 1.1, 1.3,
    //maxStepSizeX/Y
    //old kinematics:31.8, 44.0,
    34, 44,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    //old kinematics:0.05,
    0.06,
    //stepLen
    80, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset
    0, 0, 0
    )
  {}
};

/**
* @class Quick2UNSWWalkingParameters
* Parameters for InvKinWalkingEngine 
* @author Thomas Rfer
*
* QuickUNSW with higher front body. Meant for fast forward walking.
*/
class Quick2UNSWWalkingParameters : public InvKinWalkingParameters
{
public:
  Quick2UNSWWalkingParameters() : InvKinWalkingParameters(
    "Quick2UNSWClone",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    //old kinematics: 61.522046, 70.900000, 45.635928,
    76.85, 78.1, 55.88,
    //hindHeight,hindWidth,hindCenterX
    //old kinematics:95.742519, 72.600000, -49.733089,
    108.72, 76.95, -55.216,
    //foreFootLift,hindFootLift
    //old kinematics:5.000000, 27.000000,
    5.0, 24.0,
    //foreFootTilt,hindFootTilt
    //old kinematics:-0.4, -0.1,    // 0.161686, -0.148314,
    -0.25, 0.05,
    //legSpeedFactorX/Y/R
    1.1, 1.1, 1.3,
    //maxStepSizeX/Y
    //old kinematics:31.8, 44.0,
    38.0, 42.0,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    //old kinematics:0.05,
    0.055,
    //stepLen
    80, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0, 0, 0
    )
  {}
};

/**
* @class FastForwardWalkingParameters
* Parameters for InvKinWalkingEngine 
* @author Uwe Dffert
*
* Quick2UNSW with some inspiration from Austin, mainly shorter ground phase
*/
class FastForwardWalkingParameters : public InvKinWalkingParameters
{
public:
  FastForwardWalkingParameters() : InvKinWalkingParameters(
    "FastForward",
    //footMode
    1, //halfcircle
    //foreHeight,foreWidth,foreCenterX
    61.522046, 70.900000, 45.635928,
    //hindHeight,hindWidth,hindCenterX
    95.742519, 72.600000, -50.733089,
    //foreFootLift,hindFootLift
    2.000000, 47.000000, 
    //foreFootTilt,hindFootTilt
    -0.4, -0.1,
    //legSpeedFactorX/Y/R
    1.1, 1.1, 1.0,
    //maxStepSizeX/Y
    40.0, 34.0,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.05,
    //stepLen
    70, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.43, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.43, 0.06, 0.06,
    //legPhase
    0.035, 0.535, 0.535, 0.035,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0, 0, 0
    )
  {}
};

/**
* @class UpsideDownWalkingParameters
* Parameters for InvKinWalkingEngine that let robot walk upside down.
* Completely useless but looks funny
* @author Max Risler
*/
class UpsideDownWalkingParameters : public InvKinWalkingParameters
{
public:
  UpsideDownWalkingParameters() : InvKinWalkingParameters(
    "UpsideDown",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    //old kinematics:-95, 90,  50,
    -103.2, 97.4, 55.8,
    //hindHeight,hindWidth,hindCenterX
    //old kinematics:-95, 90, -50,
    -104.4, 99.4, -56.6,
    //foreFootLift,hindFootLift
    -20, -20,
    //foreFootTilt,hindFootTilt
    //old kinematics:0, 0,
    0.34, 0.11,
    //legSpeedFactorX/Y/R
    1.01, 1.5, 1.0,
    //maxStepSizeX/Y
    //old kinematics: 43.4, 20.0,
    40, 30,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    //old kinematics: 0.1,
    0.14,
    //stepLen
    120, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0, 0, 0, 0,
    //leaveAnytime
    0,
    //headTilt
    -1500000,
    //headPan
    0,
    //headRoll
    0,
    //mouth
    0
    )
  {}
};

/**
* @class TurnWithBallWalkingParameters
* Parameters for InvKinWalkingEngine that lets the robot turn 
* with the ball between its forelegs.
* @author Arthur Cesarz
* @author Matthias Hebbel
*/
class TurnWithBallWalkingParameters : public InvKinWalkingParameters
{
public:
  TurnWithBallWalkingParameters() : InvKinWalkingParameters(
    "TurnWithBall",
/*
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    37.56, 50, 100,
    //hindHeight,hindWidth,hindCenterX
    92.24, 61.7, -49.6,
    //foreFootLift,hindFootLift
    0, 27,
    //foreFootTilt,hindFootTilt
    0.164, -0.148,
    //legSpeedFactorX/Y/R
    1.012, 0.852, 0,
    //maxStepSizeX/Y
    30.007, 71.203,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0,
    //stepLen
    94, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset
    0, 0, 0
*/
    //footMode
    3, //rectangle
    //foreHeight,foreWidth,foreCenterX
    //old kinematics:47.96, 50, 100,
    53.5, 52.6,  110.5,
    //hindHeight,hindWidth,hindCenterX
    //old kinematics:96.72, 61.7, -44.6,
    110.8, 62.4, -49.8,
    //foreFootLift,hindFootLift
    //old kinematics:0, 22,
    0, 32,
    //foreFootTilt,hindFootTilt
    //old kinematics: 0, -0.148,
    0, 0.148,
    //legSpeedFactorX/Y/R
    1.012, 0.852, 0,
    //maxStepSizeX/Y
    40.606, 71.803,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.25,
    //stepLen
    84, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset
    0, 0, 0
    )
  {}
};

/**
* @class UNSW2003WalkingParameters
* Parameters for InvKinWalkingEngine that look like UNSW 2003 walk
* @author Max Risler
*
*/
class UNSW2003WalkingParameters : public InvKinWalkingParameters
{
public:
  UNSW2003WalkingParameters() : InvKinWalkingParameters(
    "UNSW2003",
    //footMode
    5, //freeFormQuad
    //foreHeight,foreWidth,foreCenterX
    64.11, 67.32, 58.51,
    //hindHeight,hindWidth,hindCenterX
    104.36, 72.76, -47.41, 
    //foreFootLift,hindFootLift
    19.63, 44.80, 
    //foreFootTilt,hindFootTilt
    0.0, 0.0,
    //legSpeedFactorX/Y/R
    0.943, 1.0, 1.0,
    //maxStepSizeX/Y
    42.97, 35.0,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.15,
    //stepLen
    80, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.45, 0.125, 0.0875,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.3, 0.1, 0.1875,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0, 0, 0, 0,
    //leaveAnytime
    1
    )
  {
    freeFormQuadPos[0][0][0] = -1.0; freeFormQuadPos[0][0][1] = 5.42; freeFormQuadPos[0][0][2] = 0.0;
    freeFormQuadPos[0][1][0] = 1.0; freeFormQuadPos[0][1][1] = -1.02; freeFormQuadPos[0][1][2] = 0.596;
    freeFormQuadPos[0][2][0] = 0.805; freeFormQuadPos[0][2][1] = -5.42; freeFormQuadPos[0][2][2] = 1.0;
    freeFormQuadPos[0][3][0] = -0.714; freeFormQuadPos[0][3][1] = -1.98; freeFormQuadPos[0][3][2] = 0.564;

    freeFormQuadPos[1][0][0] = -0.614; freeFormQuadPos[1][0][1] = -5.98; freeFormQuadPos[1][0][2] = 0.299;
    freeFormQuadPos[1][1][0] = 1.0; freeFormQuadPos[1][1][1] = -8.67; freeFormQuadPos[1][1][2] = 0.0;
    freeFormQuadPos[1][2][0] = 0.874; freeFormQuadPos[1][2][1] = 8.67; freeFormQuadPos[1][2][2] = 0.311;
    freeFormQuadPos[1][3][0] = -1.0; freeFormQuadPos[1][3][1] = -5.08; freeFormQuadPos[1][3][2] = 1.0;
  }
};

/**
* @class ERS7WalkingParameters
* Parameters for InvKinWalkingEngine that look like UNSW 2003 walk
* (adopted to ERS7)
* @author Max Risler
*/
class ERS7WalkingParameters : public InvKinWalkingParameters
{
public:
  ERS7WalkingParameters() : InvKinWalkingParameters(
    "ERS7",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    76.5308, 78.1, 53.6242,
    //hindHeight,hindWidth,hindCenterX
    108.72, 76.95, -49.56, 
    //foreFootLift,hindFootLift
    5, 24, 
    //foreFootTilt,hindFootTilt
    -0.25, 0.0450392,
    //legSpeedFactorX/Y/R
    1.1, 1.13782, 1.19384,
    //maxStepSizeX/Y
    38, 43.0719,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.055,
    //stepLen
    77, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0.800923, 0, 0, 0,
    //leaveAnytime
    1
    )
  {}
};

/**
* @class ERS7TurnWithBallWalkingParameters
* Parameters for InvKinWalkingEngine to turn with ball caught
* (adopted to ERS7)
* @author Max Risler
*/
class ERS7TurnWithBallWalkingParameters : public InvKinWalkingParameters
{
public:
  ERS7TurnWithBallWalkingParameters() : InvKinWalkingParameters(
    "ERS7TurnWithBall",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    76.5308, 78.1, 85.0,
    //hindHeight,hindWidth,hindCenterX
    108.72, 76.95, -49.56, 
    //foreFootLift,hindFootLift
    5, 24, 
    //foreFootTilt,hindFootTilt
    -0.25, 0.0450392,
    //legSpeedFactorX/Y/R
    1.1, 1.13782, 1.19384,
    //maxStepSizeX/Y
    38, 43.0719,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.055,
    //stepLen
    77, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0.800923, 0, 0, 0,
    //leaveAnytime
    1
    )
  {
  }
};


/**
 * @class   MSH2004WalkingParameters
 * @author  Thomas Kindler <thomas.kindler@gmx.de>
 *
 * 34cm/s walk, 10.03.2004
 */
class MSH2004WalkingParameters : public InvKinWalkingParameters
{
public:
  MSH2004WalkingParameters() : InvKinWalkingParameters(
    "MSH2004",

    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    77.5836, 80.2702, 50.3536,
    //hindHeight,hindWidth,hindCenterX
    105.174, 81.5432, -52.0932,
    //foreFootLift,hindFootLift
    5.24393, 24.5014,
    //foreFootTilt,hindFootTilt
    -0.251997, 0.0161507,
    //legSpeedFactorX/Y/R  
    1.16278, 1.10182, 1.14494,
    //maxStepSizeX/Y  
    37.323, 43.6967,
    //maxSpeedChangeX/Y,maxRotationChange  
    100, 100, 1,
    //counterRotation  
    0.055,
    //stepLen  
    64,
    //groundPhaseF,LiftPhaseF,LowerPhaseF  
    0.491957, 0.0833278, 0.0664729,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.49005, 0.089776, 0.0767162,
    //legPhase  
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset  
    0.800923, 0, 0, 0,
    //leaveAnytime
    1
  ) { }
};

/**
 * @class   MSH2004BackwardsWalkingParameters
 * @author  Thomas Kindler <thomas.kindler@gmx.de>
 * @author  Arthur Cesar
 * 21 cm/s 19.03.2003
 */

class MSH2004BackwardsWalkingParameters : public InvKinWalkingParameters
{
public:
  MSH2004BackwardsWalkingParameters() : InvKinWalkingParameters(
    "MSH2004Backwards",

    // 28,24 cm
    //footMode
    0, 
    //foreHeight,foreWidth,foreCenterX
    88.5057, 79.127, 43.2139, 
    //hindHeight,hindWidth,hindCenterX
    101.905, 77.6874, -49.6692, 
    //foreFootLift,hindFootLift  
    9.76973, 28.5799,
    //foreFootTilt,hindFootTilt  
    -0.0724927, 0.0922574, 
    //legSpeedFactorX/Y/R
    1.20455, 0.843727, 1.44822, 
    //maxStepSizeX/Y  
    34.8207, 38.8411,
    //maxSpeedChangeX/Y,maxRotationChange
    100, 100, 1,
    //counterRotation  
    0.06, 
    //stepLen  
    61,
    //groundPhaseF,LiftPhaseF,LowerPhaseF  
    0.461105, 0.0361205, 0.0391534,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.508829, 0.0532571, 0.0469326,
    //legPhase  
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset  
    0, 0, 0.0337565,
    //leaveAnytime
    1
  ) { }
};

/**
* @class  MSH2004TurnWithBallWalkingParameters
* @author Arthur Cesarz
* Parameter set for InvKinWalkingEngine, that holds the ball 
* between its forelegs and turns around.
*/
class MSH2004TurnWithBallWalkingParameters : public InvKinWalkingParameters
{
public:
  MSH2004TurnWithBallWalkingParameters() : InvKinWalkingParameters(
    "MSH2004TurnWithBall",

    //footMode
    3, 
    //foreHeight,foreWidth,foreCenterX
    -28.48, 50, 142.84, 
    //hindHeight,hindWidth,hindCenterX
    118, 71.58, -43.8, 
    //foreFootLift,hindFootLift
    0.04, 57.16, 
    //foreFootTilt,hindFootTilt
    0, -0.248, 
    //legSpeedFactorX/Y/R  
    0.188, 0.152, 0, 
    //maxStepSizeX/Y  
    63.404, 72.603, 
    //maxSpeedChangeX/Y,maxRotationChange  
    100, 100, 1,
    //counterRotation  
    0.25,
    //stepLen  
    39,
    //groundPhaseF,LiftPhaseF,LowerPhaseF  
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.224, 0.016, 0.162, 
    //legPhase  
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset  
    0, 0, 0, 0,
    //leaveAnytime
    1
  ) { }
};

/**
* @class ATH2004TurnWithBallWalkingParameters
* @author Uwe Dueffert
* Parameter set for InvKinWalkingEngine, that holds the ball 
* between its forelegs and turns around.
*/
class ATH2004TurnWithBallWalkingParameters : public InvKinWalkingParameters
{
public:
  ATH2004TurnWithBallWalkingParameters() : InvKinWalkingParameters(
    "ATH2004TurnWithBall",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX (even foreWidth=74 works. is that still ball holding?)
    48, 60, 120,
    //hindHeight,hindWidth,hindCenterX
    132, 84, -49.4,
    //foreFootLift,hindFootLift
    0, 44,
    //foreFootTilt,hindFootTilt
    0, 0,
    //legSpeedFactorX/Y/R  
    1, 1, 1,
    //maxStepSizeX/Y  
    10, 60,
    //maxSpeedChangeX/Y,maxRotationChange  
    100, 100, 1,
    //counterRotation  
    0,
    //stepLen  
    64,
    //groundPhaseF,LiftPhaseF,LowerPhaseF  
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase  
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset  
    0, 0, 0, 0,
    //leaveAnytime
    1,
    //headTilt, headPan, headRoll
    -370000, 0, 870000,
    //mouth
    0
  ) { }
};

/**
* @class DDDERS7WalkingParameters
* Parameters for InvKinWalkingEngine that look like UNSW 2003 walk
* (adopted to ERS7)
* @author Dirk Thomas
*/
class DDDERS7WalkingParameters : public InvKinWalkingParameters
{
public:
  DDDERS7WalkingParameters() : InvKinWalkingParameters(
    "DDDERS7",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    76.5, 77, 51,
    //hindHeight,hindWidth,hindCenterX
    109, 77, -63, 
    //foreFootLift,hindFootLift
    5, 24, 
    //foreFootTilt,hindFootTilt
    -0.25, 0.05,
    //legSpeedFactorX/Y/R
    1.18, 1.14, 1.2,
    //maxStepSizeX/Y
    40, 44,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.02,
    //stepLen
    74, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0.8, 0, 0, 0,
    //leaveAnytime
    1
    )
  {}
};

/**
* @class DDDERS7TurnWithBallWalkingParameters
* Parameters for InvKinWalkingEngine that look like UNSW 2003 walk
* (adopted to ERS7)
* @author Dirk Thomas
*/
class DDDERS7TurnWithBallWalkingParameters : public InvKinWalkingParameters
{
public:
  DDDERS7TurnWithBallWalkingParameters() : InvKinWalkingParameters(
    "DDDERS7TurnWithBall",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    76.5, 77, 91,
    //hindHeight,hindWidth,hindCenterX
    109, 77, -63, 
    //foreFootLift,hindFootLift
    5, 24, 
    //foreFootTilt,hindFootTilt
    -0.25, 0.05,
    //legSpeedFactorX/Y/R
    1.18, 1.14, 1.2,
    //maxStepSizeX/Y
    40, 44,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.02,
    //stepLen
    74, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0.8, 0, 0, 0,
    //leaveAnytime
    1
    )
  {}
};

/**
* @class DDDERS7FastWalkingParameters
* Parameters for InvKinWalkingEngine that look like Jolly Pochie walk
* @author Dirk Thomas
*/
class DDDERS7FastWalkingParameters : public InvKinWalkingParameters
{
public:
  DDDERS7FastWalkingParameters() : InvKinWalkingParameters(
    "DDDERS7fast",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    110, 70, 30,
    //hindHeight,hindWidth,hindCenterX
    115, 70, -40, 
    //foreFootLift,hindFootLift
    33, 15,
    //foreFootTilt,hindFootTilt
    0.0, 0.0,
    //legSpeedFactorX/Y/R
    1.0, 1.0, 1.0,
    //maxStepSizeX/Y
    38, 35,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.2,
    //stepLen
    40,
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.04, 0.04,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.04, 0.04,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0, 0, 0, 0,
    //leaveAnytime
    1
    )
  {}
};

#endif// __InvKinWalkingParameterSets_h_

/*
 * Change log :
 * 
 * $Log: InvKinWalkingParameterSets.h,v $
 * Revision 1.18  2004/04/08 15:33:06  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.17  2004/04/07 12:29:00  risler
 * ddd checkin after go04 - first part
 *
 * Revision 1.6  2004/04/02 23:44:40  dthomas
 * added new invKinParams for turn with ball
 * integrated into rotate-around-ball
 * combined with updated catch-ball head-control-mode
 *
 * Revision 1.5  2004/03/31 11:54:18  dthomas
 * minor reduce sideward speed of dddErs7fast
 *
 * Revision 1.4  2004/03/31 10:08:07  dthomas
 * added new parameterset for ers7 based on jolly pochie
 *
 * Revision 1.3  2004/03/29 21:13:42  dthomas
 * small improvements in direction and correct counterRotation
 *
 * Revision 1.2  2004/03/29 10:06:24  dthomas
 * added new ers7 walking engine parameters
 *
 * Revision 1.1.1.1  2004/03/29 08:28:46  Administrator
 * initial transfer from tamara
 *
 * Revision 1.16  2004/03/29 16:26:42  dueffert
 * sign bug fixed
 *
 * Revision 1.15  2004/03/29 15:24:25  dueffert
 * new turn parameterset
 *
 * Revision 1.14  2004/03/26 09:20:29  dueffert
 * ::ERS7 beautified
 *
 * Revision 1.13  2004/03/17 01:10:51  cesarz
 * added MSH2004TurnWithBallWalkingParameters
 *
 * Revision 1.12  2004/03/15 21:23:50  kindler
 * - changed name of MSH parameters to "MSH2004"
 *
 * Revision 1.11  2004/03/10 17:45:21  kindler
 * - Added MSH2004 InvKinWalkingEngine parameter set.
 *
 * Revision 1.10  2004/03/09 15:37:03  dueffert
 * doxygen bug fixed; beautified
 *
 * Revision 1.9  2004/03/04 18:20:03  juengel
 * Added ERS7TurnWithBallWalkingParameters.
 *
 * Revision 1.8  2004/03/02 10:10:54  mellmann
 * new parameterset for ERS7
 *
 * Revision 1.7  2004/02/16 17:56:32  dueffert
 * InvKin engine and parameters separated
 *
 */
