/**
 * MSH2004InvKinWalkingEngine
 *
 * @author Thomas Kindler <thomas.kindler@gmx.de>
 */
#include "MSH2004InvKinWalkingEngine.h"
#include "Platform/GTAssert.h"
#include "Tools/Location.h"
#include "Tools/Debugging/Debugging.h"

/**
 * Construct a new MSH Walking engine
 *
 * @param  pEngine  InvKinWalkingEngine to use.
 *
 */
MSH2004InvKinWalkingEngine::MSH2004InvKinWalkingEngine(
  InvKinWalkingEngine  *pEngine
)
  : WalkingEngine(*pEngine), pEngine(pEngine)
{
}


/**
 * Calculates the next joint data set. 
 *
 * @param   jointData      stores calculated frame  
 * @param   motionRequest  the current motion request  
 *
 * @return  true if next set should be calculated by WalkingEngine,
 *          false if change to other module can occur 
 * 
 */
bool MSH2004InvKinWalkingEngine::executeParameterized(
        JointData      &jointData,
  const MotionRequest  &motionRequest
)
{ 
  char *paramType = "";

  if (motionRequest.walkParams.translation.x  > -50 ||
      fabs(motionRequest.walkParams.rotation) >   2  ) {
    paramType = "fast";
    pEngine->setParameters(&forward);
  } else {
    paramType = "conservative";
    pEngine->setParameters(&backward);
  }
  
  INFO( sendWalkingEngineInfo, idText, text,
    "walkParams: "
    "x = " << motionRequest.walkParams.translation.x << ", " <<
    "y = " << motionRequest.walkParams.translation.y << ", " <<
    "r = " << motionRequest.walkParams.rotation      << " -> " <<
    "using " << paramType << " parameters."
  );
 
  bool   result = pEngine->executeParameterized(jointData, motionRequest);
  return result;
}


bool MSH2004InvKinWalkingEngine::handleMessage(InMessage& message)
{
  return pEngine->handleMessage(message);
}

