/**
 * @file
 * This file contains the implementation of a sender for motor commands.
 */

#include "ProcessFramework.h"
#include "Tools/Debugging/Debugging.h"

MotorCommandsSender::MotorCommandsSender(PlatformProcess* process,bool blocking)
: SenderBase<MotorCommands>(process,"Sender.OCommandVectorData.S",blocking),
  jointGainsSet(false)
{
  //package = 0;
  numOfLED = 3; //LEDValue::numOfLED_ERS110;
  //2do: richtig machen
  //VERIFY(OPENR::NewCommandVectorData(JointData::numOfJoint + numOfLED,&memID,&cmdVec) == oSUCCESS);
  cmdVec->SetNumData(JointData::numOfJoint + numOfLED);

  //OPENR::SetMotorPower(opowerON);

  for(int i = 0; i < JointData::numOfJoint; i++) 
  {
    //OPENR::OpenPrimitive((const char*) getPrimitiveJointName(i),&jointId[i]);
    //OPENR::EnableJointGain(jointId[i]);
    OCommandInfo* info = cmdVec->GetInfo(i);
    info->Set(odataJOINT_COMMAND,jointId[i],jointDataBufferNumOfFrames);
  }

  OPrimitiveID id;
  
  for(int i = 0; i < numOfLED; i++) 
  {
    //OPENR::OpenPrimitive((const char*) getPrimitiveLEDName(i),&id);
    OCommandInfo* info = cmdVec->GetInfo(JointData::numOfJoint + i);
    info->Set(odataLED_COMMAND,id,jointDataBufferNumOfFrames);
  }
}

MotorCommandsSender::~MotorCommandsSender()
{
  //2do: richtig
  //VERIFY(OPENR::DeleteCommandVectorData(memID) == oSUCCESS);
}

void MotorCommandsSender::preparePackage()
{
/*
  if(!package)
    package = new RCRegion(cmdVec->vectorInfo.memRegionID,
                           cmdVec->vectorInfo.offset,
                           (void*) cmdVec,
                           cmdVec->vectorInfo.totalSize);
*/
  const MotorCommands& motorCommands = *static_cast<const MotorCommands*>(this);
/*
  for (int i = 0; i < JointData::numOfJoint; i++)
    if(!jointGainsSet ||
       motorCommands.pidData.p[i] != lastPidData.p[i] ||
       motorCommands.pidData.i[i] != lastPidData.i[i] ||
       motorCommands.pidData.d[i] != lastPidData.d[i])
    {
      OPENR::SetJointGain(jointId[i], 
        motorCommands.pidData.p[i],
        motorCommands.pidData.i[i],
        motorCommands.pidData.d[i],
        0x0E, 0x02, 0x0F);
      lastPidData.p[i] = motorCommands.pidData.p[i];
      lastPidData.i[i] = motorCommands.pidData.i[i];
      lastPidData.d[i] = motorCommands.pidData.d[i];
    }
*/
  jointGainsSet = true;

  long value;
  for(int k = 0; k < JointData::numOfJoint; ++k)
  {
    OCommandData* data = cmdVec->GetData(k);
    for(int l = 0; l < jointDataBufferNumOfFrames; ++l) 
    {
      value = motorCommands.jointDataBuffer.frame[l].data[k];
      if(value == jointDataInvalidValue) 
        value = 0;
      ((OJointCommandValue *)data->value)[l].value = value;
    }
  }

/*
  for(int k = 0; k < numOfLED; ++k) 
  {
    OCommandData* data = cmdVec->GetData(JointData::numOfJoint + k);
    for(int l = 0; l < jointDataBufferNumOfFrames; l++)
    {
      ((OLEDCommandValue2 *)data->value)[l].period = 1;
      ((OLEDCommandValue2 *)data->value)[l].led = (motorCommands.ledValue.data[l] >> k) & 1;
    }
  }
*/
}

void MotorCommandsSender::setPackage(const ObserverID& receiver)
{
  //VERIFY(SetData(receiver,package) == oSUCCESS);

//if (subject->NumberOfReference(cmdVector[bufID]->GetDataVectorID(),(u_int)0) != 0)

  //2do: we should use 2 cmdVec filled alternatingly
  //SetData(cmdVec->GetDataVectorID(), 0);
}

void MotorCommandsSender::freePackage()
{
  // package is not freed
}

/*
 * Change log :
 * 
 * $Log$
 *
 */
