/**
 * @file Platform/Aperios1.2.1/ProcessFramework.cpp
 * This file implements classes related to processes on the Aperios Platform.
 */
#include "ProcessFramework.h"

void ProcessBase::aperiosInit(OReasonMessage* reasonMsg)
{
  theInstance->Init(OSystemEvent(reasonMsg->reason,reasonMsg->param,reasonMsg->paramSize));
  Return();
}

void ProcessBase::aperiosStart(OReasonMessage* reasonMsg)
{
  theInstance->Start(OSystemEvent(reasonMsg->reason,reasonMsg->param,reasonMsg->paramSize));
  Return();
}

void ProcessBase::aperiosStop(OReasonMessage* reasonMsg)
{
  theInstance->Stop(OSystemEvent(reasonMsg->reason,reasonMsg->param,reasonMsg->paramSize));
  Return();
}

void ProcessBase::aperiosDestroy(OReasonMessage* reasonMsg)
{
  theInstance->Destroy(OSystemEvent(reasonMsg->reason,reasonMsg->param,reasonMsg->paramSize)); 
  Return();
}

void ProcessBase::awakeOnTimer(OReasonMessage* reasonMsg)
{
  setEventId(31);
  Exit();
}

/*  
void ProcessBase::antListenCont(antEnvMsg* msg)
{
  // When the message was send to the ANT-lib its continuation
  // field was set to the address of the Endpoint. So this calls
  // the listenCont funtion of the right IPEndpoint
  // cout << "ProcessBase::antListenCont " << msg << "\n";
  (static_cast<IPEndpoint*>(msg->continuation))->listenCont(msg);
  // cout << "ProcessBase::antListenCont done \n";
  Return();
}

void ProcessBase::antConnectCont(antEnvMsg* msg)
{
  //cout << "ProcessBase::antConnectCont " << msg << "\n";
  (static_cast<IPEndpoint*>(msg->continuation))->connectCont(msg);
  //cout << "ProcessBase::antConnectCont done \n";
  Return();
}

void ProcessBase::antReceiveCont(antEnvMsg* msg)
{
  //cout << "ProcessBase::antReceiveCont " << msg << "\n";
  (static_cast<IPEndpoint*>(msg->continuation))->receiveCont(msg);
  //cout << "ProcessBase::antReceiveCont done \n ";
  Return();
}  

void ProcessBase::antSendCont(antEnvMsg* msg)
{
  //cout << "ProcessBase::antSendCont " << msg << "\n";
  (static_cast<IPEndpoint*>(msg->continuation))->sendCont(msg);
  //cout << "ProcessBase::antSendCont done \n";
  Return();
}

void ProcessBase::antCloseCont(antEnvMsg* msg)
{
  //cout << "ProcessBase::antCloseCont " << msg << "\n";
  (static_cast<IPEndpoint*>(msg->continuation))->closeCont(msg);
  //cout << "ProcessBase::antCloseCont done \n";
  Return();
}

void ProcessBase::getAntInformation(int*& listenContSelector, int*& sendContSelector,
                 int*& receiveContSelector, int*& closeContSelector, 
                 int*& connectContSelector)
{
    listenContSelector = &antListenContSelector;
    sendContSelector = &antSendContSelector;
    receiveContSelector = &antReceiveContSelector;
    closeContSelector = &antCloseContSelector;
    connectContSelector = &antConnectContSelector;   
}
*/
void ProcessBase::init()
{
  AlignedBlock entryTablePool[AlignedSize(SIZEOF_ENTRYTABLE(ENTRY_TABLE_MAX))];
  int numOfEntries = ENTRY_TABLE_MIN + getProcess()->getFirstReceiver()->getNumberOfTableEntries()
                                     + getProcess()->getFirstSender()->getNumberOfTableEntries(),
      id = 0;
  ASSERT(numOfEntries <= ENTRY_TABLE_MAX);
  EntryTable* entryTable = new (entryTablePool) EntryTable(numOfEntries);
  entryTable->SetEntry(id++,(Entry) aperiosInit);
  entryTable->SetEntry(id++,(Entry) aperiosStart);
  entryTable->SetEntry(id++,(Entry) aperiosStop);
  entryTable->SetEntry(id++,(Entry) aperiosDestroy);
  entryTable->SetEntry(id++,(Entry) awakeOnTimer);
  for(ReceiverList* p = getProcess()->getFirstReceiver(); p; p = p->getNext())
    id = p->fillEntryTable(entryTable,id);
  for(SenderList* q = getProcess()->getFirstSender(); q; q = q->getNext())
    id = q->fillEntryTable(entryTable,id);
  VERIFY(SetEntryTable(numOfEntries,entryTable) == sSUCCESS);

  // Entrys for IP-networking
/*
  ObjectEntryTable[id].selector = id;
  antListenContSelector = id;
  ObjectEntryTable[id++].entry = (Entry) antListenCont;
  
  ObjectEntryTable[id].selector = id;
  antReceiveContSelector = id;
  ObjectEntryTable[id++].entry = (Entry) antReceiveCont;

  ObjectEntryTable[id].selector = id;
  antSendContSelector = id;
  ObjectEntryTable[id++].entry = (Entry) antSendCont;

  ObjectEntryTable[id].selector = id;
  antCloseContSelector = id;
  ObjectEntryTable[id++].entry = (Entry) antCloseCont;

  ObjectEntryTable[id].selector = id;
  antConnectContSelector = id;
  ObjectEntryTable[id++].entry = (Entry) antConnectCont;
  
  ASSERT(id <= ENTRY_TABLE_MAX);
 
  ObjectEntryTable[id].selector = UNDEF;
  //ObjectEntryTable[id].entry = ENTRY_UNDEF;
  ObjectEntryTable[id].entry = NULL;
*/
}

void ProcessBase::nextFrame()
{
  if(theInstance->isRunning())
    theInstance->processNextFrame();
}

void ProcessBase::setBlockingId(int id,bool block)
{
  if(block)
    blockMask |= 1 << id;
  else
    blockMask &= ~(1 << id);
}

void ProcessBase::setEventId(int id)
{
  eventMask |= 1 << id;
  if(blockMask && (eventMask & blockMask) == blockMask)
  {
    blockMask = 0;
    nextFrame();
  }
}

/*
 * Change log :
 * 
 * $Log$
 *
 */
