/**
 * @file Platform/Aperios1.2.1/Receiver.cpp
 * This file implements classes related to receivers for Aperios.
 */
#include "ProcessFramework.h"

ReceiverList::ReceiverList(PlatformProcess* p,const char* receiverName,bool blocking)
{
  process = p;
  // copy the receiver's name. The name of the process is still missing.
  strcpy(this->name,receiverName);
  if(getFirst())
  {
    ReceiverList* p = getFirst();
    while(p->next)
      p = p->next;
    p->next = this;
  }
  else
    getFirst() = this;
  next = 0;
  this->blocking = blocking;
}

ReceiverList*& ReceiverList::getFirst()
{
  return process->getFirstReceiver();
}

int ReceiverList::getNumberOfTableEntries()
{
  int count = 0;
  ReceiverList* p = getFirst();
  while(p)
  {
    p = p->getNext();
    count += 2;
  }
  return count;
}

bool ReceiverList::receivedNew() const
{
  return (ProcessBase::getEventMask() & 1 << eventId) != 0;
}

void ReceiverList::finishFrame()
{
  for(ReceiverList* p = getFirst(); p; p = p->getNext())
  {
    ProcessBase::setBlockingId(p->eventId,p->blocking);
    if(p->receivedNew())
      p->AssertReady();
  }
}

void ReceiverList::setBlockingId(int id,bool block)
{
  ProcessBase::setBlockingId(id,block);
}

void ReceiverList::setEventId(int id)
{
  ProcessBase::setEventId(id);
}

/*
 * Change log :
 * 
 * $Log$
 *
 */
