/**
 * @file Platform/Aperios1.2.1/Sender.cpp
 * This file implements classes related to senders for Aperios.
 * @author Thomas Rfer
 */
#include "ProcessFramework.h"

SenderList::SenderList(PlatformProcess* p,const char* senderName,bool blocking)
{
  // copy the sender's name. The name of the process is still missing.
  process = p;
  strcpy(this->name,senderName);
  if(getFirst())
  {
    SenderList* p = getFirst();
    while(p->next)
      p = p->next;
    p->next = this;
  }
  else
    getFirst() = this;
  next = 0;
  this->blocking = blocking;
}

SenderList*& SenderList::getFirst()
{
  return process->getFirstSender();
}

int SenderList::getNumberOfTableEntries()
{
  int count = 0;
  SenderList* p = getFirst();
  while(p)
  {
    p = p->getNext();
    count += 2;
  }
  return count;
}

void SenderList::finishFrame()
{
  for(SenderList* p = getFirst(); p; p = p->getNext())
    p->sendPackage();
}

void SenderList::setBlockingId(int id,bool block)
{
  ProcessBase::setBlockingId(id,block);
}

void SenderList::setEventId(int id)
{
  ProcessBase::setEventId(id);
}

/*
 * Change log :
 * 
 * $Log: Sender.cpp,v $
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/12/02 11:00:13  dueffert
 * doxygen docu corrected
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/07/06 15:28:28  roefer
 * Prologue function removed
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2001/12/15 20:32:08  roefer
 * Senders and receivers are now part of the processes
 *
 * Revision 1.2  2001/12/10 17:47:08  risler
 * change log added
 *
 */
