/** 
* @file  Platform/Aperios1.2.1/SystemCall.h
* @brief static class for system calls from the non NDA classes
*
* @author <A href="mailto:brunn@sim.informatik.tu-darmstadt.de">Ronnie Brunn</A>
* @author <A href="mailto:risler@sim.informatik.tu-darmstadt.de">Max Risler</A>
*/

#ifndef	_SYSTEMCALL_H_
#define	_SYSTEMCALL_H_

class RobotDesign
{
public:
  /**
  * The design of the robot.
  */
  enum Design 
  {
    UNKNOWN,
    ERS210, 
    ERS7,
    ERS110
  };
};

/**
* static class for system calls
* @attention the implementation is system specific!
*/
class SystemCall
{
public:
  /** returns the current system time in milliseconds
  */
  static unsigned long getCurrentSystemTime ();
  
  /** returns the time since aTime
  */
  static unsigned long getTimeSince (unsigned long aTime) {
    return (getCurrentSystemTime() - aTime);
  }

  /** returns the amount of free memory
    */
  static unsigned long getFreeMem();

  /** returns the amount of remaining battery power in percent
    * or 100 if the robot is attached to powerline
    */
  static unsigned char getRemainingPower();

  /** reboots the robot */
  static void reboot();

  /** shuts the robot down */
  static void shutdown();

  /** returns the robot's mac address */
  static void getMacAddress(unsigned char address[6]);

  /** returns the robot's design */
  static RobotDesign::Design getRobotDesign();
};


#endif // _SYSTEMCALL_H_

/*
 * Change log :
 * 
 * $Log$
 *
 */
