/**
* @file Platform/Aperios1.3.2/Sensors.h
*
* Declaration of class Sensors and streaming operators for images and sensor data
* for Aperios platform
*
* @author Thomas Rfer
* @author Martin Ltzsch
* @author Sebastian Petters
* @author Joscha Bach
*/

#ifndef __Sensors_h_
#define __Sensors_h_

#include "Representations/Perception/SensorDataBuffer.h"
#include "Representations/Perception/Image.h"
#include "Representations/Perception/CameraParameters.h"

/**
 * @class Sensors
 * base class for sensor processes
 *
 * @author Joscha Bach
 */
 
class Sensors 
{
  public:
  /**
  * constructor.
  * reads camera parameters from file or sets defaults if no file exists 
  */	
  Sensors(); 
  /**
  * sets Camera Parameters with CameraParameters ;-/ 
  */	
  void setCameraParameters (CameraParameters &cameraParameters);
  protected:
  CameraParameters cameraParameters;
};

/**
 * Streaming operator that converts system-dependent images into the portable class Image.
 * @todo Implement copying from OFbkImageVectorData to Image.
 * @param stream The stream from which is read.
 * @param image The system independent image object.
 * @return The stream.
 */ 
In& operator>>(In& stream,Image& image);

/**
 * The macro instantiates a receiver for an Image.
 * The Image receiver is system-specific.
 * For Aperios, an Image receiver must be registered as OFbkImageVectorData.
 * @param blocking Decides whether this sender blocks the execution of the next frame
 *                 until all connected receivers have requested a new package.
 */
#define INIT_RECEIVER_IMAGE(blocking) \
  theImageReceiver(this,"Receiver.OFbkImageVectorData.O",blocking)

/**
 * Streaming operator that converts system-dependent sensor data into the portable class SensorDataBuffer.
 * @param stream The stream from which is read.
 * @param sensorDataBuffer The system independent sensor data buffer object.
 * @return The stream.
 */ 
In& operator>>(In& stream,SensorDataBuffer& sensorDataBuffer);

/**
 * The macro instantiates a receiver for SensorDataBuffer.
 * The SensorDataBuffer receiver is system-specific.
 * For Aperios, a SensorDataBuffer receiver must be registered as OSensorFrameVectorData.
 * @param blocking Decides whether this sender blocks the execution of the next frame
 *                 until all connected receivers have requested a new package.
 */
#define INIT_RECEIVER_SENSORDATA(blocking) \
  theSensorDataBufferReceiver(this,"Receiver.OSensorFrameVectorData.O",blocking)

#endif //__Sensors_h_

/*
 * Change log :
 * 
 * $Log: Sensors.h,v $
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:30:28  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2003/05/02 18:26:18  risler
 * SensorDataBuffer added
 * replaced SensorData with SensorDataBuffer
 * full SensorData resolution now accessible
 *
 * Revision 1.3  2002/09/16 15:55:16  dueffert
 * Martins changes to Win32 adapted to Aperios
 *
 * Revision 1.2  2002/09/11 17:26:31  loetzsch
 * continued change of module/solution mechanisms
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.7  2002/08/26 19:06:16  hebbel
 * index for INIT_RECEIVER_SOUNDDATAIN corrected
 *
 * Revision 1.6  2002/08/14 17:11:00  dueffert
 * adapted by Thomas Roefer to OPENR_SDK-1.1.3-r1 and OPENR_SYS-007
 *
 * Revision 1.5  2002/07/23 13:39:39  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - new design of debugging architecture
 * - exchanged StaticQueue with MessageQueue
 *
 * Revision 1.4  2002/07/13 12:41:39  roefer
 * New command and sound sender
 *
 * Revision 1.3  2002/07/13 10:54:58  roefer
 * New command and sound sender
 *
 * Revision 1.2  2002/05/14 21:06:58  hebbel
 * in operator for SoundDataIn included
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2001/12/19 16:03:55  bach
 * SystemDataTypes replaced by Sensors
 * 
 */
