/**
 * @file Platform/Aperios1.3.2/SoundDataSender.cpp
 * This file contains the implementation of a sender for sound data.
 */

#include "ProcessFramework.h"

SoundDataSender::SoundDataSender(PlatformProcess* process,bool blocking)
: SenderBase<SoundData>(process,"Sender.OSoundVectorData.S",blocking)
{
  package[0] = 0;

  OPrimitiveID soundId;
  VERIFY(OPENR::OpenPrimitive(SystemCall::getRobotDesign() == RobotDesign::ERS210 
                              ? "PRM:/r1/c1/c2/c3/s1-Speaker:S1"
                              : "PRM:/s1-Speaker:S1",&soundId) == oSUCCESS);
  OSpeakerSoundType type = ospksndMONO8K8B;
  VERIFY(OPENR::ControlPrimitive(soundId,oprmreqSPEAKER_SET_SOUND_TYPE,&type,sizeof(type),0,0) == oSUCCESS);
  int vol = SystemCall::getRobotDesign() == RobotDesign::ERS210 ? 0xf400 : 0xf600;
  VERIFY(OPENR::ControlPrimitive(soundId,oprmreqSPEAKER_SET_VOLUME,&vol,sizeof(vol),0,0) == oSUCCESS);

  for(int i = 0; i < 2; ++i)
  {
    VERIFY(OPENR::NewSoundVectorData(1, 256, &memID[i], &soundVec[i]) == oSUCCESS);
    soundVec[i]->SetNumData(1);
    OSoundInfo* info = soundVec[i]->GetInfo(0);
    info->Set(odataSOUND_VECTOR,soundId,info->maxDataSize);
  }
}

SoundDataSender::~SoundDataSender()
{
  for(int i = 0; i < 2; ++i)
    VERIFY(OPENR::DeleteSoundVectorData(memID[i]) == oSUCCESS);
}

void SoundDataSender::prepare(int i)
{
  const SoundData& soundData = *static_cast<const SoundData*>(this);
  OSoundInfo* info = soundVec[i]->GetInfo(0);
  info->dataSize = info->frameSize;
  info->samplingRate  = 8000;
  info->bitsPerSample = 8;
  memcpy(soundVec[i]->GetData(0),soundData.pcmBuffer,256);
}

void SoundDataSender::preparePackage()
{
  if(!package[0])
  {
    for(int i = 0; i < 2; ++i)
    {
      VERIFY(package[i] = new RCRegion(soundVec[i]->vectorInfo.memRegionID,
                                       soundVec[i]->vectorInfo.offset,
                                       (void*) soundVec[i],
                                       soundVec[i]->vectorInfo.totalSize));
      prepare(i);
    }
    index = -1;
  }
  else
    prepare(index);
}

void SoundDataSender::setPackage(const ObserverID& receiver)
{
  for(int l = 0; l < 2; l++)
  {
    if (package[l]->NumberOfReference() == 1)
    {
      VERIFY(SetData(receiver,package[l]) == oSUCCESS);
    }
  }
}

/** @todo packages are not freed */
void SoundDataSender::freePackage()
{
  if(index == -1)
    index = 0;
  else
    index = 1 - index;
}

/*
 * Change log :
 * 
 * $Log: SoundDataSender.cpp,v $
 * Revision 1.2  2003/12/31 18:14:45  roefer
 * Sound for ERS-7
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2002/12/02 11:00:13  dueffert
 * doxygen docu corrected
 *
 * Revision 1.2  2002/11/28 14:46:17  dueffert
 * doxygen docu corrected
 *
 * Revision 1.1  2002/11/28 14:22:01  hebbel
 * added SoundDataSender
 *
 * Revision 1.3  2002/08/26 21:04:26  hebbel
 * Changed method setPackage() to support double-buffering
 *
 * Revision 1.2  2002/08/14 17:11:00  dueffert
 * adapted by Thomas Roefer to OPENR_SDK-1.1.3-r1 and OPENR_SYS-007
 *
 * Revision 1.1  2002/07/13 10:54:58  roefer
 * New command and sound sender
 *
 *
 *
 */
