/** 
* @file  Platform/Aperios1.3.2/TCPHandler.h
*
* Class for using NetSender/NetReceivers over a TCP connection
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
*/

#ifndef	_TCPHandler_H_
#define	_TCPHandler_H_

class TCPHandler;

#include "TCPEndpoint.h"
#include "NetHandler.h"
#include "NetSender.h"
#include "NetReceiver.h"

class TCPHandler : public TCPEndpoint, public NetHandler
{
   public:
     TCPHandler(){};
     TCPHandler(NetSenderBase& theSender, NetReceiverBase& theReceiver);
     void setTransmitters(NetSenderBase& theSender, NetReceiverBase& theReceiver);
     virtual void onReceive(void* someData, int size);  
     virtual void onConnect(void);
     virtual void onClose(int reason);
     virtual void onSendingDone(void);
     virtual void sendPackage(int senderNumber,void* someData,int size);
     
   private:
     NetReceiverBase* receiver;
     NetSenderBase* sender;

     void* receiveBuffer;
     int sizeOfDataToRead;
     bool sendingDone;
};


#endif 

/*
 *
 * Changelog :
 *
 * $Log: TCPHandler.h,v $
 * Revision 1.4  2004/01/20 14:21:41  wachter
 * - Added sender-number to NetSender
 * - worked on with Team-Communication
 *
 * Revision 1.3  2004/01/03 18:57:50  wachter
 * Debug-communication working now
 *
 * Revision 1.2  2004/01/03 16:18:25  wachter
 * debug-communication mostly working now
 *
 * Revision 1.1  2003/12/21 19:27:03  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 *
 */
