/** 
* @file  Platform/Aperios1.3.2/UDPEndpoint.h
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
*/

#ifndef	_UDPEndpoint_H_
#define	_UDPEndpoint_H_

/**
* static class for system calls
* @attention the implementation is system specific!
*/

#include "IPEndpoint.h"
#include <UDPEndpointMsg.h>

class UDPEndpoint : public IPEndpoint
{
    public:
       UDPEndpoint(int sendBufferSize = 2048, int receiveBufferSize=2048);
      
       ~UDPEndpoint();

       /** binds endpoint to listen to port */
       int bind(int listenPort);     
 
       /** binds endpoint to listen to port and sets receiving host
           to address:port */
       int bind(int listenPort, char* address, int sendPort); 
       int bind(Port listenPort, IPAddress address, Port sendPort);
         
       /** sends data from the shared buffer (does no copy of data) */
       int send(int size);
	   
	   /** sends data from the shared buffer to a givern host/port */
	   int send(int size, char* addr, int sPort);

       /** sends data to last specified other host (copies the data)*/
       int send(void* data,int size);

       /** sends data to other host */
       int send(void* data,int size, char* address,int port);

       /** sends data to other host */
       int send(void* data,int size, IPAddress address, int port);

       /** Called when new data arrives */
       virtual void onReceive(void* data,int size);

       /** Called from close() when connection closes */
       virtual void onClose();
	   virtual void onSendingDone();

       /** Closes Endpoint in case of an error an error */
       void close();

       const char* getErrorString(UDPEndpointError error);
       const char* getErrorString();

       virtual void sendCont(antEnvMsg* msg);
       virtual void receiveCont(antEnvMsg* msg);
       virtual void closeCont(antEnvMsg* msg);
     
    protected: 
       IPAddress ipOfLastPackage;

    private:
       IPAddress address; /* IP address of the receiver */
       Port sendPort; /* port of the receiver */
       Port listenPort; /* port to listen for data */
       void startReceiving();
       
};
   


#endif 

/*
 * Change log :
 * 
 * $Log: UDPEndpoint.h,v $
 * Revision 1.5  2004/01/26 13:44:07  wachter
 * shared-memory-buffers now have variable sizes
 *
 * Revision 1.4  2004/01/09 15:44:30  wachter
 * Worked on with the Dog-Discovery-Protocol
 *
 * Revision 1.3  2003/12/11 15:02:37  wachter
 * Low-level TCP and UDP functions for aperios now working.
 *
 * Revision 1.2  2003/12/10 09:56:42  dueffert
 * doxygen bugs fixed
 *
 * Revision 1.1  2003/12/03 14:21:52  wachter
 * Splitted IPEndpoint.*
 *
 *
 */
