/** 
* @file  Platform/Linux/SystemCall.cpp
*
* Static class for system calls, aperios implementation.
* @attention this is the Aperios implementation
*
* @author <A href=mailto:brunn@sim.informatik.tu-darmstadt.de>Ronnie Brunn</A>
* @author <A href=mailto:risler@sim.informatik.tu-darmstadt.de>Max Risler</A>
*/

#include <sys/timeb.h>
#include "SystemCall.h"

/** returns the current system time in milliseconds
*/
unsigned long SystemCall::getCurrentSystemTime() {
  timeb sysTime;
  ftime(&sysTime);
  return (sysTime.time * 1000 + sysTime.millitm);
}

/*
 * Change log :
 * 
 * $Log: SystemCall.cpp,v $
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/05/02 17:04:09  roefer
 * New router
 *
 * Revision 1.4  2001/12/10 17:47:08  risler
 * change log added
 *
 */
